/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.FloatListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionFloatCollection;
import org.apache.commons.collections.primitives.adapters.FloatCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListFloatList;
import org.apache.commons.collections.primitives.adapters.ListIteratorFloatListIterator;

abstract class AbstractListFloatList
extends AbstractCollectionFloatCollection
implements FloatList {
    AbstractListFloatList() {
    }

    public void add(int index, float element) {
        this.getList().add(index, new Float(element));
    }

    public boolean addAll(int index, FloatCollection collection) {
        return this.getList().addAll(index, FloatCollectionCollection.wrap(collection));
    }

    public float get(int index) {
        return ((Number)this.getList().get(index)).floatValue();
    }

    public int indexOf(float element) {
        return this.getList().indexOf(new Float(element));
    }

    public int lastIndexOf(float element) {
        return this.getList().lastIndexOf(new Float(element));
    }

    public FloatListIterator listIterator() {
        return ListIteratorFloatListIterator.wrap(this.getList().listIterator());
    }

    public FloatListIterator listIterator(int index) {
        return ListIteratorFloatListIterator.wrap(this.getList().listIterator(index));
    }

    public float removeElementAt(int index) {
        return ((Number)this.getList().remove(index)).floatValue();
    }

    public float set(int index, float element) {
        return ((Number)this.getList().set(index, new Float(element))).floatValue();
    }

    public FloatList subList(int fromIndex, int toIndex) {
        return ListFloatList.wrap(this.getList().subList(fromIndex, toIndex));
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatList) {
            FloatList that = (FloatList)obj;
            if (this == that) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            FloatIterator thisiter = this.iterator();
            FloatIterator thatiter = that.iterator();
            while (thisiter.hasNext()) {
                if (thisiter.next() == thatiter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }

    protected final Collection getCollection() {
        return this.getList();
    }

    protected abstract List getList();
}

