/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: VersionConverter.java 2360 2012-06-11 10:24:36Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-3.0-alpha-1/src/main/java/org/nuiton/util/converter/VersionConverter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util.converter;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import static org.nuiton.i18n.I18n._;

/**
 * classe pour convertir une chaine en un objet Version.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see Version
 * @since 1.3 (replace {@code org.nuiton.util.VersionConverter}).
 */
public class VersionConverter implements Converter {

    /** Logger. */
    private static final Log log = LogFactory.getLog(VersionConverter.class);

    public VersionConverter() {
        if (log.isDebugEnabled()) {
            log.debug("init version converter " + this);
        }
    }

    @Override
    public Object convert(Class aClass, Object value) {
        if (value == null) {
            throw new ConversionException(
                    _("nuitonutil.error.convertor.noValue", this));
        }
        if (isEnabled(aClass)) {
            Object result;
            if (isEnabled(value.getClass())) {
                result = value;
                return result;
            }
            if (value instanceof String) {
                try {
                    result = VersionUtil.valueOf((String) value);
                    return result;
                } catch (IllegalArgumentException e) {
                    throw new ConversionException(
                            _("nuitonutil.error.version.convertor", value, this, e.getMessage()), e);
                }
            }
        }
        throw new ConversionException(
                _("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    protected boolean isEnabled(Class<?> aClass) {
        return Version.class.equals(aClass);
    }

    public Class<?> getType() {
        return Version.class;
    }
}
