/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuiton.AbstractPlugin;
import org.nuiton.license.License;
import org.nuiton.license.LicenseFactory;
import org.nuiton.license.plugin.HeaderGenerator;
import org.nuiton.processor.LicenseProcessor;
import org.nuiton.util.PluginHelper;

public abstract class AbstractUpdateHeaderPlugin
extends AbstractPlugin {
    protected MavenProject project;
    protected String encoding;
    protected boolean force;
    protected String inceptionYear;
    protected String organizationName;
    protected String projectName;
    protected String licenseName;
    protected List<String> compileSourceRoots;
    protected List<String> testCompileSourceRoots;
    protected File outputDirectory;
    protected File testOutputDirectory;
    protected String[] extraResolver;
    protected String extraIncludes;
    protected boolean keepBackup;
    protected boolean verbose;
    protected String licenseHeaderContent;
    protected Map<File, String[]> filesToTreate;
    protected HeaderGenerator generator;
    protected long timestamp;

    public AbstractUpdateHeaderPlugin() {
        super("all files are up-to-date.");
    }

    protected abstract Map<File, String[]> getFilesToTreate();

    protected abstract HeaderGenerator newHeaderGenerator();

    public HeaderGenerator getGenerator() {
        return this.generator;
    }

    public boolean ensurePackaging() {
        return "pom".equals(this.project.getPackaging()) || "site".equals(this.project.getPackaging());
    }

    public boolean init() throws IOException {
        boolean doGenerate;
        this.timestamp = System.nanoTime();
        this.filesToTreate = this.getFilesToTreate();
        boolean bl = doGenerate = !this.filesToTreate.isEmpty();
        if (doGenerate) {
            LicenseFactory factory = LicenseFactory.newInstance((String[])this.extraResolver);
            License license = factory.revolv(this.licenseName);
            this.licenseHeaderContent = this.computeHeader(license);
            this.generator = this.newHeaderGenerator();
            if (this.verbose) {
                this.getLog().info((CharSequence)("config - header to write on files \n" + this.licenseHeaderContent));
                this.getLog().info((CharSequence)("config - will use the generator " + this.generator));
            }
        } else {
            this.getLog().info((CharSequence)"no jaxx file to treate.");
        }
        return doGenerate;
    }

    protected void doAction() throws Exception {
        LicenseProcessor p = new LicenseProcessor(this.licenseHeaderContent);
        for (Map.Entry<File, String[]> entry : this.filesToTreate.entrySet()) {
            File src = entry.getKey();
            for (String javaRelativePath : entry.getValue()) {
                File sourceFile = new File(src, javaRelativePath);
                try {
                    this.processFile(p, sourceFile);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("could not treate java source file " + sourceFile + " for reason : " + e.getMessage(), e);
                }
            }
        }
    }

    protected String computeHeader(License license) throws IOException {
        String tmpHeader = license.getHeaderContent(this.encoding);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String thisYear = cal.get(1) + "";
        if (!thisYear.equals(this.inceptionYear)) {
            this.inceptionYear = this.inceptionYear + " - " + thisYear;
        }
        tmpHeader = String.format(tmpHeader, this.projectName, this.inceptionYear, this.organizationName);
        BufferedReader reader = new BufferedReader(new StringReader(tmpHeader));
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        sb.append(line).append('\n');
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) {
                sb.append(" *\n");
                continue;
            }
            sb.append(" * ").append(line).append("\n");
        }
        tmpHeader = sb.toString();
        return tmpHeader.substring(0, tmpHeader.length() - 1);
    }

    protected void processFile(LicenseProcessor p, File file) throws Exception {
        if (this.verbose) {
            this.getLog().info((CharSequence)("process file " + file));
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
        try {
            p.process(file, processFile);
            boolean foundLicenseHeader = p.getLicenceFilter().wasTouched();
            if (!foundLicenseHeader) {
                this.addHeaderToFile(file, processFile);
            }
            if (this.keepBackup) {
                File backupFile = new File(file.getAbsolutePath() + "~");
                if (this.verbose) {
                    this.getLog().debug((CharSequence)("backup original file " + file));
                }
                file.renameTo(backupFile);
            }
            processFile.renameTo(file);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("could not process file " + file + " for reason " + e.getMessage()), (Throwable)e);
            processFile.delete();
            throw e;
        }
        finally {
            p.getLicenceFilter().reset();
        }
    }

    protected void addHeaderToFile(File sourceFile, File processFile) throws IOException {
        this.getLog().warn((CharSequence)("no license header was found on file " + processFile + ", adding one"));
        String content = PluginHelper.readAsString((File)sourceFile, (String)this.encoding);
        content = this.getGenerator().getHeader(this.licenseHeaderContent) + content;
        this.writeFile(processFile, content, this.encoding);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected void getExtraFilesToTreate(Map<File, String[]> files) {
        if (this.extraIncludes != null && !this.extraIncludes.isEmpty()) {
            String[] includes = this.extraIncludes.split(",");
            this.getFilesToTreateForRoots(includes, null, this.compileSourceRoots, files, null);
            this.getFilesToTreateForRoots(includes, null, this.testCompileSourceRoots, files, null);
        }
    }
}

