/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.license.License;

public class LicenseResolver {
    protected static final Log log = LogFactory.getLog(LicenseResolver.class);
    protected String baseURL;
    protected Map<String, String> licenseNames;

    public LicenseResolver() {
    }

    public LicenseResolver(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
        this.licenseNames = null;
    }

    public Map<String, String> getLicenseNames() {
        if (this.licenseNames == null) {
            if (this.baseURL == null || this.baseURL.trim().isEmpty()) {
                throw new IllegalArgumentException("no baseURL defined in " + this);
            }
            TreeMap<String, String> list = new TreeMap<String, String>();
            try {
                URL licenseURL = new URL(this.baseURL + "/licenses.properties");
                if (!this.checkExists(licenseURL)) {
                    throw new IllegalArgumentException("no licenses.properties found withurl [" + licenseURL + "] for resolver " + this);
                }
                Properties p = new Properties();
                p.load(licenseURL.openStream());
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    list.put((String)entry.getKey(), entry.getValue() + " [" + this.baseURL + "]");
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                return null;
            }
            this.licenseNames = Collections.unmodifiableMap(list);
        }
        return this.licenseNames;
    }

    public License resolv(String licenseName) throws IllegalArgumentException {
        if (this.baseURL == null || this.baseURL.trim().isEmpty()) {
            throw new IllegalArgumentException("no baseURL defined in " + this);
        }
        if (licenseName == null || licenseName.trim().isEmpty()) {
            throw new IllegalArgumentException("licenceName can not be null");
        }
        licenseName = licenseName.trim().toLowerCase();
        if (!this.getLicenseNames().containsKey(licenseName)) {
            return null;
        }
        try {
            URL licenseURL = new URL(this.baseURL + "/" + licenseName + "/license.txt");
            URL headerURL = new URL(this.baseURL + "/" + licenseName + "/header.txt");
            if (!this.checkExists(licenseURL) || !this.checkExists(headerURL)) {
                return null;
            }
            License license = new License();
            license.setName(licenseName);
            license.setLicenseURL(licenseURL);
            license.setHeaderURL(headerURL);
            return license;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return super.toString() + "<baseURL:" + this.baseURL + ", licenseNames:" + this.licenseNames + ">";
    }

    protected boolean checkExists(URL url) throws IOException {
        return url.openConnection().getContentLength() > 0;
    }
}

