/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.nuiton.license.JarLicenseResolver;
import org.nuiton.license.License;
import org.nuiton.license.LicenseResolver;

public class LicenseFactory {
    protected List<LicenseResolver> resolvers = new ArrayList<LicenseResolver>();

    public static LicenseFactory newInstance(String ... extraResolvers) throws IllegalArgumentException {
        LicenseFactory result = new LicenseFactory();
        result.addResolver(new JarLicenseResolver());
        if (extraResolvers != null) {
            for (String extraResolver : extraResolvers) {
                if (extraResolver == null || extraResolver.trim().isEmpty()) continue;
                result.addResolver(new LicenseResolver(extraResolver));
            }
        }
        return result;
    }

    public void addResolver(LicenseResolver licenseResolver) {
        this.resolvers.add(licenseResolver);
    }

    public Map<String, String> getLicenseNames() throws IllegalArgumentException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (LicenseResolver resolver : this.resolvers) {
            Map<String, String> tmp = resolver.getLicenseNames();
            for (Map.Entry<String, String> s : tmp.entrySet()) {
                if (result.containsKey(s.getKey())) continue;
                result.put(s.getKey(), s.getValue());
            }
        }
        return result;
    }

    public License revolv(String licenseName) throws IllegalArgumentException {
        if (licenseName == null) {
            throw new IllegalArgumentException("licenseName can not be null");
        }
        for (LicenseResolver resolver : this.resolvers) {
            License result = resolver.resolv(licenseName);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException("could not find the license " + licenseName + " with resolvers" + this.resolvers);
    }

    protected LicenseFactory() throws IllegalArgumentException {
    }
}

