/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.license.plugin.LicensePlugin;
import org.nuiton.util.BasePluginTestCase;
import org.nuiton.util.PluginConfig;

public class LicensePluginTest
extends BasePluginTestCase {
    @BeforeClass
    public static void initClass() throws Exception {
        LicensePluginTest.initConfigs(LicensePluginTest.class, "testOne");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        configItr = null;
        testDir = null;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        LicensePlugin plugin = (LicensePlugin)this.mojo;
        plugin.setOutputDirectory(new File(LicensePluginTest.getBaseDir(), plugin.getOutputDirectory().toString()));
        if (!plugin.getOutputDirectory().exists() && !plugin.getOutputDirectory().mkdirs()) {
            throw new IOException("could not create directory : " + plugin.getOutputDirectory());
        }
        plugin.setLicenseFile(new File(this.pomFile.getParentFile(), plugin.getLicenseFile().toString()));
    }

    @Test
    @PluginConfig(pomName="testOne.xml", goalName="add-license")
    public void testOne() throws MojoExecutionException, MojoFailureException {
        Assert.assertNotNull((Object)this.mojo);
        LicensePlugin p = (LicensePlugin)this.mojo;
        long t0 = p.getLicenseFile().lastModified();
        p.getProject().getFile().setLastModified(0L);
        p.execute();
        long t1 = p.getLicenseFile().lastModified();
        Assert.assertEquals((long)t0, (long)t1);
        p.setForce(true);
        p.execute();
        t1 = p.getLicenseFile().lastModified();
        Assert.assertTrue((t1 > t0 ? 1 : 0) != 0);
    }
}

