/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.js.wro;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.util.ObjectFactory;

public class NuitonJsWroConfigurationFactory
implements ObjectFactory<WroConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(NuitonJsWroConfigurationFactory.class);
    protected FilterConfig filterConfig;

    public NuitonJsWroConfigurationFactory() {
    }

    public NuitonJsWroConfigurationFactory(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public final WroConfiguration create() {
        return new PropertyWroConfigurationFactory(this.initProperties()).create();
    }

    protected String getUserConfigPath() {
        return "/WEB-INF/nuiton-js.properties";
    }

    protected Properties getDefaultConfig() {
        Properties result = new Properties();
        result.setProperty("managerFactoryClassName", "org.nuiton.js.wro.NuitonJsWroManagerFactory");
        result.setProperty("debug", "true");
        result.setProperty("preProcessors", "cssUrlRewriting,cssImport,semicolonAppender,cssMinJawr");
        result.setProperty("postProcessors", "cssVariables,jsMin");
        result.setProperty("uriLocators", " servletContext,uri,classpath");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties initProperties() {
        Properties result = this.getDefaultConfig();
        InputStream propertyStream = null;
        String file = this.getUserConfigPath();
        try {
            LOG.debug("loading config resource from: {}", (Object)file);
            propertyStream = this.loadAsStream(file);
            Validate.notNull((Object)propertyStream);
            Properties props = new Properties();
            props.load(propertyStream);
            result.putAll((Map<?, ?>)props);
        }
        catch (Exception e) {
            try {
                LOG.error("[FAIL] Cannot read properties file stream from default location: {}. Using default configuration.", (Object)file);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(propertyStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)propertyStream);
        }
        IOUtils.closeQuietly((InputStream)propertyStream);
        return result;
    }

    protected InputStream loadAsStream(String file) throws Exception {
        InputStream result = this.getServletContext().getResourceAsStream(file);
        return result;
    }

    protected ServletContext getServletContext() {
        ServletContext result = this.filterConfig != null ? this.filterConfig.getServletContext() : Context.get().getServletContext();
        return result;
    }
}

