/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.ChangesDocument;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.plugins.changes.model.io.xpp3.ChangesXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="generate-changelog")
public class GenerateChangelogMojo
extends AbstractPlugin {
    @Parameter(property="redmine.xmlPath", defaultValue="${basedir}/src/changes/changes.xml", required=true)
    protected File xmlPath;
    @Parameter(property="redmine.outputFile", defaultValue="${project.build.directory}/changelog.txt", required=true)
    protected File outputFile;
    @Parameter(property="redmine.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="redmine.attach")
    protected boolean attach;
    @Parameter(property="redmine.skipGenerateChangelog")
    protected boolean skipGenerateChangelog;
    @Parameter(property="redmine.generateOnce", defaultValue="true")
    protected boolean generateOnce;
    @Parameter(property="redmine.runOnlyOnRoot", defaultValue="true")
    protected boolean runOnlyOnRoot;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    private MavenProjectHelper mavenProjectHelper;

    protected boolean checkSkip() {
        Date newStartTime;
        if (this.skipGenerateChangelog) {
            this.getLog().info((CharSequence)"Skipping goal skipGenerateChangelog flag is on).");
            return false;
        }
        Date buildStartTime = this.session == null ? null : this.session.getStartTime();
        boolean needInvoke = this.needInvoke(this.generateOnce, this.runOnlyOnRoot, buildStartTime, newStartTime = this.outputFile != null && this.outputFile.exists() ? new Date(this.outputFile.lastModified()) : null);
        if (!needInvoke) {
            this.getLog().info((CharSequence)"Skipping goal (runOnce flag is on, and was already executed).");
        }
        return needInvoke;
    }

    protected void init() throws Exception {
        if (!this.xmlPath.exists()) {
            throw new MojoExecutionException("Could not find xmlPath: " + this.xmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        ChangesDocument changesDocument;
        this.getLog().info((CharSequence)("Loading changes.xml from file: " + this.xmlPath));
        ChangesXpp3Reader reader = new ChangesXpp3Reader();
        FileReader fileReader = new FileReader(this.xmlPath);
        try {
            changesDocument = reader.read((Reader)fileReader);
            ((Reader)fileReader).close();
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
        this.getLog().info((CharSequence)("Generate changelog in file: " + this.outputFile));
        String eol = SystemUtils.LINE_SEPARATOR;
        FileWriter writer = new FileWriter(this.outputFile);
        try {
            List releases = changesDocument.getBody().getReleases();
            for (Release release : releases) {
                String action;
                String issue;
                List fixedIssues;
                String dueTo;
                String dev;
                Action a;
                writer.append(eol).append("Version ").append(release.getVersion()).append(" - ").append(release.getDateRelease()).append(eol);
                for (Object o : release.getActions("add")) {
                    a = (Action)o;
                    dev = a.getDev();
                    dueTo = a.getDueTo();
                    fixedIssues = a.getFixedIssues();
                    issue = a.getIssue();
                    action = a.getAction();
                    writer.append(" o Feature #").append(issue).append(" ").append("due to ").append(dueTo).append(", thanks to ").append(dev).append(" - ").append(action).append(eol);
                }
                for (Object o : release.getActions("fix")) {
                    a = (Action)o;
                    dev = a.getDev();
                    dueTo = a.getDueTo();
                    fixedIssues = a.getFixedIssues();
                    issue = a.getIssue();
                    action = a.getAction();
                    writer.append(" o Bug     #").append(issue).append(" ").append("due to ").append(dueTo).append(", thanks to ").append(dev).append(" - ").append(action).append(eol);
                }
                for (Object o : release.getActions("update")) {
                    a = (Action)o;
                    dev = a.getDev();
                    dueTo = a.getDueTo();
                    fixedIssues = a.getFixedIssues();
                    issue = a.getIssue();
                    action = a.getAction();
                    writer.append(" o Task    #").append(issue).append(" ").append("due to ").append(dueTo).append(", thanks to ").append(dev).append(" - ").append(action).append(eol);
                }
            }
            writer.close();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        if (this.attach) {
            this.getLog().info((CharSequence)"Attach changelog file as *changelog* classifier.");
            this.mavenProjectHelper.attachArtifact(this.project, this.outputFile, "changelog");
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

