/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestException;
import org.nuiton.jredmine.RedmineServiceConfiguration;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class RedmineConfigurationUtil {
    private static final Log log = LogFactory.getLog(RedmineConfigurationUtil.class);
    public static final String PROPERTY_PREFIX = "jredmine-test.";

    protected RedmineConfigurationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedmineServiceConfiguration obtainRedmineConfiguration(RedmineServiceConfiguration anoConf) throws IOException {
        RedmineServiceConfiguration conf = RedmineConfigurationUtil.newLogguedConfiguration(anoConf);
        boolean ok = false;
        RedmineRestClient client = new RedmineRestClient(conf);
        try {
            client.open();
            ok = client.isOpen();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not connect to redmine with configuration: " + conf), (Throwable)e);
            }
        }
        finally {
            block27: {
                try {
                    client.close();
                }
                catch (RestException e) {
                    if (!log.isErrorEnabled()) break block27;
                    log.error((Object)"Could not close session", (Throwable)e);
                }
            }
        }
        if (!ok) {
            conf = RedmineConfigurationUtil.cloneConfiguration(anoConf);
            client = new RedmineRestClient(conf);
            try {
                client.open();
                ok = client.isOpen();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not connect to redmine with configuration: " + conf), (Throwable)e);
                }
            }
            finally {
                block29: {
                    try {
                        client.close();
                    }
                    catch (RestException e) {
                        if (!log.isErrorEnabled()) break block29;
                        log.error((Object)"Could not close session", (Throwable)e);
                    }
                }
            }
        }
        if (!ok) {
            conf = null;
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedmineServiceConfiguration newAnonymousConfiguration(String propertiesFromEnv, String classPathPropertiesLocation) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        try {
            String jredmineConfiguration = System.getenv(propertiesFromEnv);
            if (jredmineConfiguration == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not find environement variable 'jredmine-test.properties' will use default test configuration");
                }
                in = RedmineConfigurationUtil.class.getResourceAsStream(classPathPropertiesLocation);
            } else {
                File file = new File(jredmineConfiguration);
                if (!file.exists()) {
                    throw new IllegalStateException("Could not find " + jredmineConfiguration + " file");
                }
                in = FileUtils.openInputStream((File)file);
            }
            props.load(in);
            in.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        SimpleRedmineServiceConfiguration result = new SimpleRedmineServiceConfiguration();
        RedmineConfigurationUtil.overridePropertyFromProperties(result, "url", "restUrl", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(result, "encoding", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(result, "verbose", props);
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "url", "restUrl");
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "encoding");
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "verbose");
        result.setAnonymous(true);
        return result;
    }

    public static RedmineServiceConfiguration newLogguedConfiguration(RedmineServiceConfiguration anoConf) throws IOException {
        RedmineServiceConfiguration result = RedmineConfigurationUtil.cloneConfiguration(anoConf);
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "login", "restUsername");
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "password", "restPassword");
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "apiKey", "apiKey");
        result.setAnonymous(false);
        return result;
    }

    public static RedmineServiceConfiguration cloneConfiguration(RedmineServiceConfiguration src) {
        SimpleRedmineServiceConfiguration dst = new SimpleRedmineServiceConfiguration();
        dst.setRestUrl(src.getRestUrl());
        dst.setRestUsername(src.getRestUsername());
        dst.setRestPassword(src.getRestPassword());
        dst.setApiKey(src.getApiKey());
        dst.setEncoding(src.getEncoding());
        dst.setVerbose(src.isVerbose());
        dst.setAnonymous(src.isAnonymous());
        return dst;
    }

    public static void copyConfiguration(RedmineServiceConfiguration src, RedmineServiceConfiguration dst) {
        dst.setRestUrl(src.getRestUrl());
        dst.setRestUsername(src.getRestUsername());
        dst.setRestPassword(src.getRestPassword());
        dst.setApiKey(src.getApiKey());
        dst.setEncoding(src.getEncoding());
        dst.setVerbose(src.isVerbose());
        dst.setAnonymous(src.isAnonymous());
    }

    protected static void overridePropertyFromProperties(RedmineServiceConfiguration conf, String prop, Properties props) throws IOException {
        RedmineConfigurationUtil.overridePropertyFromProperties(conf, prop, prop, props);
    }

    protected static void overridePropertyFromProperties(RedmineServiceConfiguration conf, String prop, String beanProp, Properties props) throws IOException {
        String value = props.getProperty(PROPERTY_PREFIX + prop);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                BeanUtilsBean.getInstance().setProperty((Object)conf, beanProp, (Object)value);
            }
            catch (Exception e) {
                throw new IOException("Could not set property '" + beanProp + "' with value '" + value + "' to configuration");
            }
        }
    }

    protected static void overridePropertyFromEnv(RedmineServiceConfiguration conf, String prop) throws IOException {
        RedmineConfigurationUtil.overridePropertyFromEnv(conf, prop, prop);
    }

    protected static void overridePropertyFromEnv(RedmineServiceConfiguration conf, String prop, String beanProp) throws IOException {
        String value = System.getenv(PROPERTY_PREFIX + prop);
        if (StringUtils.isNotEmpty((CharSequence)value) && !"null".equals(value)) {
            try {
                BeanUtilsBean.getInstance().setProperty((Object)conf, beanProp, (Object)value);
            }
            catch (Exception e) {
                throw new IOException("Could not set property '" + prop + "' with value '" + value + "' to configuration");
            }
        }
    }

    public static class SimpleRedmineServiceConfiguration
    implements RedmineServiceConfiguration {
        URL restUrl;
        String restUsername;
        String restPassword;
        boolean verbose;
        boolean anonymous;
        String encoding;
        String apiKey;

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getRestPassword() {
            return this.restPassword;
        }

        public void setRestPassword(String restPassword) {
            this.restPassword = restPassword;
        }

        public URL getRestUrl() {
            return this.restUrl;
        }

        public void setRestUrl(URL restUrl) {
            this.restUrl = restUrl;
        }

        public String getRestUsername() {
            return this.restUsername;
        }

        public void setRestUsername(String restUsername) {
            this.restUsername = restUsername;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean isAnonymous() {
            return this.anonymous;
        }

        public void setAnonymous(boolean anonymous) {
            this.anonymous = anonymous;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
            b.append("redmineUrl", (Object)this.restUrl);
            if (this.anonymous) {
                b.append("anonymous", true);
            } else {
                b.append("redmineUsername", (Object)this.restUsername);
                b.append("redminePassword", (Object)"***");
            }
            b.append("encoding", (Object)this.encoding);
            b.append("verbose", this.verbose);
            return b.toString();
        }

        @Override
        public String getApiKey() {
            return this.apiKey;
        }

        @Override
        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }
    }
}

