/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: DefaultRedmineAnonymousServiceTest.java 186 2011-05-20 12:32:08Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2/jredmine-client/src/test/java/org/nuiton/jredmine/DefaultRedmineAnonymousServiceTest.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine;

import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.rest.RedmineRestClient;

/**
 * Created: 2 janv. 2010
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 186 $
 *          <p/>
 *          Mise a jour: $Date: 2011-05-20 14:32:08 +0200 (Fri, 20 May 2011) $ par :
 *          $Author: tchemit $
 */
public class DefaultRedmineAnonymousServiceTest extends AbstractRedmineServiceTest<DefaultRedmineAnonymousService> {

    public DefaultRedmineAnonymousServiceTest() {
        super(DefaultRedmineAnonymousService.class);
    }

    @Override
    protected RedmineRestClient newClient(RestClientConfiguration configuration) {
        configuration.setAnonymous(true);
        return super.newClient(configuration);
    }

    @Test
    @Override
    public void getUserProjects() throws Exception {
        // not for anonymous service
    }

    @Test
    @Override
    public void addVersion() throws Exception {
        // not for anonymous service
    }

    @Test
    @Override
    public void addAttachment() throws Exception {
        // not for anonymous service
    }

    @Test
    @Override
    public void addNews() throws Exception {
        // not for anonymous service
    }

    @Test
    @Override
    public void updateVersion() throws Exception {
        // not for anonymous service
    }

    @Test
    @Override
    public void nextVersion() throws Exception {
        // not for anonymous service
    }

    @Test
    @Override
    public void addIssueTime() throws Exception {
        // not for anonymous service
    }


}
