/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.io.xpp3.RedmineXpp3Helper;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class DefaultRedmineService
implements RedmineService,
RedmineServiceImplementor {
    protected static final Log log = LogFactory.getLog(DefaultRedmineService.class);
    protected RestClient session;
    protected final RedmineXpp3Helper xpp3Helper = new RedmineXpp3Helper();
    protected boolean init;

    public DefaultRedmineService() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new " + this));
        }
    }

    @Override
    public Version addVersion(String projectName, Version version) throws RedmineServiceException {
        this.checkInit();
        RestRequest r = this.getRequest(RedmineRestClient.ADD_VERSION, projectName, version);
        try {
            InputStream stream = this.session.sendData(r);
            Version v = this.getDataFromStream(Version.class, stream);
            return v;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not send for reason " + e.getMessage(), e);
        }
    }

    @Override
    public Attachment addAttachment(String projectName, String versionName, Attachment attachement) throws RedmineServiceException {
        this.checkInit();
        RestRequest r = this.getRequest(RedmineRestClient.ADD_ATTACHMENT, projectName, versionName, attachement);
        try {
            InputStream stream = this.session.sendData(r);
            Attachment v = this.getDataFromStream(Attachment.class, stream);
            return v;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not send for reason " + e.getMessage(), e);
        }
    }

    @Override
    public News addNews(String projectName, News news) throws RedmineServiceException {
        this.checkInit();
        RestRequest r = this.getRequest(RedmineRestClient.ADD_NEWS, projectName, news);
        try {
            InputStream stream = this.session.sendData(r);
            News v = this.getDataFromStream(News.class, stream);
            return v;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not send for reason " + e.getMessage(), e);
        }
    }

    @Override
    public Version updateVersion(String projectName, Version version) throws RedmineServiceException {
        this.checkInit();
        RestRequest r = this.getRequest(RedmineRestClient.UPDATE_VERSION, projectName, version);
        try {
            InputStream stream = this.session.sendData(r);
            Version v = this.getDataFromStream(Version.class, stream);
            return v;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not send for reason " + e.getMessage(), e);
        }
    }

    @Override
    public Version nextVersion(String projectName, String oldVersionName, Version newVersion) throws RedmineServiceException {
        this.checkInit();
        RestRequest r = this.getRequest(RedmineRestClient.NEXT_VERSION, projectName, oldVersionName, newVersion);
        try {
            InputStream stream = this.session.sendData(r);
            Version v = this.getDataFromStream(Version.class, stream);
            return v;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not send for reason " + e.getMessage(), e);
        }
    }

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        return this.getDatas(IssueStatus.class, new Object[0]);
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        return this.getDatas(IssuePriority.class, new Object[0]);
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        return this.getDatas(Project.class, new Object[0]);
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        return this.getDatas(IssueCategory.class, projectName);
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        return this.getData(Project.class, projectName);
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        return this.getDatas(Tracker.class, projectName);
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        return this.getDatas(News.class, projectName);
    }

    @Override
    public User[] getUsers(String projectName) throws RedmineServiceException {
        return this.getDatas(User.class, projectName);
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        return this.getDatas(Version.class, projectName);
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        return this.getData(Version.class, projectName, versionName);
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        return this.getDatas(Attachment.class, projectName, versionName);
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        return this.getDatas(Issue.class, projectName, versionName);
    }

    @Override
    public boolean isInit() {
        return this.init;
    }

    @Override
    public RedmineServiceImplementor init(RestClientConfiguration configuration) throws RedmineServiceException {
        this.session.setConfiguration(configuration);
        RedmineServiceImplementor result = this.init(this.session);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClient session) throws RedmineServiceException {
        if (this.init) {
            throw new IllegalStateException("the client " + this + " was already init!");
        }
        try {
            this.session = session;
            if (!session.isOpen()) {
                session.open();
            }
            this.init = true;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not init service for reason " + e.getMessage(), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws RedmineServiceException {
        block6: {
            this.checkInit();
            try {
                if (!this.session.isOpen()) break block6;
                try {
                    this.session.close();
                }
                catch (RestException ex) {
                    throw new RedmineServiceException("has problem while closing Rest client " + ex.getMessage(), ex);
                }
            }
            finally {
                if (this.session != null) {
                    this.session = null;
                }
                this.init = false;
            }
        }
    }

    @Override
    public <T> T getData(Class<T> type, Object ... args) throws RedmineServiceException {
        this.checkInit();
        InputStream stream = this.getDataStream(type, args);
        if (stream == null) {
            return null;
        }
        T result = this.getDataFromStream(type, stream);
        return result;
    }

    @Override
    public <T> T[] getDatas(Class<T> type, Object ... args) throws RedmineServiceException {
        this.checkInit();
        InputStream stream = this.getDatasStream(type, args);
        if (stream == null) {
            return null;
        }
        T[] result = this.getDatasFromStream(type, stream);
        return result;
    }

    @Override
    public <T> InputStream getDataStream(Class<T> type, Object ... args) throws RedmineServiceException {
        InputStream stream = this.getDataStream(type, false, args);
        return stream;
    }

    @Override
    public <T> InputStream getDatasStream(Class<T> type, Object ... args) throws RedmineServiceException {
        InputStream stream = this.getDataStream(type, true, args);
        return stream;
    }

    protected <T> InputStream getDataStream(Class<T> type, boolean array, Object ... args) throws RedmineServiceException {
        String requestName = type.getName() + (array ? "list" : "detail");
        RestRequest r = this.getRequest(requestName, args);
        try {
            InputStream stream = this.session.askData(r);
            return stream;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not botain data stream for type " + type + " for reason " + e.getMessage(), e);
        }
    }

    protected RestRequest getRequest(String requestName, Object ... args) throws RedmineServiceException {
        RestRequest r;
        try {
            r = this.session.getRequest(requestName, args);
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not find the request named " + requestName + " for reason " + e.getMessage(), e);
        }
        if (r == null) {
            throw new RedmineServiceException("could not find the request named " + requestName);
        }
        return r;
    }

    protected <T> T getDataFromStream(Class<T> type, InputStream stream) throws RedmineServiceException {
        try {
            T result = this.xpp3Helper.readObject(type, stream);
            return result;
        }
        catch (IOException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
        catch (XmlPullParserException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
    }

    protected <T> T[] getDatasFromStream(Class<T> type, InputStream stream) throws RedmineServiceException {
        try {
            T[] result = this.xpp3Helper.readObjects(type, stream);
            return result;
        }
        catch (IOException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
        catch (XmlPullParserException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
    }

    protected void checkInit() throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("the client " + this + " is not init!");
        }
    }
}

