/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.swing.extra.table.renderer.I18nTableCellRenderer;

public class JTables {
    private static final Log log = LogFactory.getLog(JTables.class);

    public static void selectFirstCellOnFirstRowAndStopEditing(JTable table) {
        JTables.doSelectCell(table, 0, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void selectFirstCellOnLastRow(JTable table) {
        JTables.doSelectCell(table, table.getRowCount() - 1, 0);
    }

    public static void selectFirstCellOnRow(JTable table, int row, boolean stopEdit) {
        JTables.doSelectCell(table, row, 0);
        if (stopEdit && table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void doSelectCell(JTable table, int rowIndex, int columnIndex) {
        int rowCount = table.getRowCount();
        if (rowCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No row in table, can not select any cell");
            }
            return;
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No column in table, can not select any cell");
            }
            return;
        }
        if (columnIndex > columnCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("ColumnIndex: %s is more than columnCount %s", columnIndex, columnCount));
            }
            columnIndex = columnCount - 1;
        }
        if (columnIndex < 0) {
            columnIndex = 0;
        }
        if (rowIndex >= rowCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("RowIndex: %s is more than rowCount %s", rowIndex, rowCount));
            }
            rowIndex = rowCount - 1;
        }
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        table.setColumnSelectionInterval(columnIndex, columnIndex);
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.editCellAt(rowIndex, columnIndex);
    }

    public static void makeTableTabFocusable(final JTable table) {
        table.setCellSelectionEnabled(true);
        table.setSurrendersFocusOnKeystroke(true);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    int selectedColumn = table.getSelectedColumn();
                    int selectedRow = table.getSelectedRow();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Selected was row[" + selectedRow + "] column[" + selectedColumn + "]"));
                    }
                    int columnCount = table.getColumnCount();
                    int rowCount = table.getRowCount();
                    for (int toSelectColumn = selectedColumn; toSelectColumn < columnCount; ++toSelectColumn) {
                        if (!JTables.editCell(table, selectedRow, toSelectColumn)) continue;
                        return;
                    }
                    for (int toSelectRow = selectedRow; toSelectRow < rowCount; ++toSelectRow) {
                        for (int toSelectColumn = 0; toSelectColumn < columnCount; ++toSelectColumn) {
                            if (!JTables.editCell(table, toSelectRow, toSelectColumn)) continue;
                            return;
                        }
                    }
                }
            }
        });
    }

    public static boolean editCell(JTable table, int row, int colummn) {
        boolean result = false;
        if (table.isCellEditable(row, colummn)) {
            if (table.isEditing()) {
                int editingRow = table.getEditingRow();
                int editingColumn = table.getEditingColumn();
                TableCellEditor cellEditor = table.getCellEditor(editingRow, editingColumn);
                cellEditor.stopCellEditing();
            }
            table.setColumnSelectionInterval(colummn, colummn);
            table.setRowSelectionInterval(row, row);
            result = table.editCellAt(row, colummn, new EventObject(table));
            Component component = table.getEditorComponent();
            component.requestFocus();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Select row[" + row + "] column[" + colummn + "] return : " + result));
            }
        }
        return result;
    }

    public static void ensureRowIndex(TableModel model, int rowIndex) throws ArrayIndexOutOfBoundsException {
        if (rowIndex < -1 || rowIndex >= model.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("the rowIndex was " + rowIndex + ", but should be int [0," + (model.getRowCount() - 1) + "]");
        }
    }

    public static void ensureColumnIndex(TableModel model, int index) throws ArrayIndexOutOfBoundsException {
        if (index < -1 || index >= model.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("the columnIndex was " + index + ", but should be int [0," + (model.getColumnCount() - 1) + "]");
        }
    }

    public static void scrollToTableSelection(final JTable table) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)e.getSource();
                int firstIndex = e.getFirstIndex();
                int lastIndex = e.getLastIndex();
                Integer newSelectedRow = null;
                if (!listSelectionModel.isSelectionEmpty()) {
                    if (listSelectionModel.isSelectedIndex(firstIndex)) {
                        newSelectedRow = firstIndex;
                    } else if (listSelectionModel.isSelectedIndex(lastIndex)) {
                        newSelectedRow = lastIndex;
                    }
                }
                if (newSelectedRow != null) {
                    Rectangle rect = table.getCellRect(newSelectedRow, 0, true);
                    table.scrollRectToVisible(rect);
                }
            }
        });
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        I18nTableCellRenderer defaultRenderer = new I18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles);
        table.getTableHeader().setDefaultRenderer(defaultRenderer);
    }

    public static int[] getSelectedModelRows(JTable table) {
        int[] selectedRows = table.getSelectedRows();
        int length = selectedRows.length;
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            int selectedRow = selectedRows[i];
            result[i] = table.convertRowIndexToModel(selectedRow);
        }
        return result;
    }

    public static int getSelectedModelRow(JTable table) {
        int result = table.getSelectedRow();
        if (result != -1) {
            result = table.convertRowIndexToModel(result);
        }
        return result;
    }

    public static int getSelectedModelColumn(JTable table) {
        int result = table.getSelectedColumn();
        if (result != -1) {
            result = table.convertColumnIndexToModel(result);
        }
        return result;
    }

    public static void setSelectionInterval(JTable table, int rowIndex) {
        int rowViewIndex = table.convertRowIndexToView(rowIndex);
        table.getSelectionModel().setSelectionInterval(rowViewIndex, rowViewIndex);
    }

    public static void addRowSelectionInterval(JTable table, int rowIndex) {
        int rowViewIndex = table.convertRowIndexToView(rowIndex);
        table.getSelectionModel().addSelectionInterval(rowViewIndex, rowViewIndex);
    }

    public static int computeTableColumnWidth(JTable table, Font font, int columnIndex, String suffix) {
        int width = 0;
        if (font == null) {
            font = table.getFont();
        }
        FontMetrics fontMetrics = table.getFontMetrics(font);
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String key = (String)table.getModel().getValueAt(i, 0);
            int w = fontMetrics.stringWidth(key + suffix);
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public static void fixTableColumnWidth(JTable table, int columnIndex, int width) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setMaxWidth(width);
        column.setMinWidth(width);
        column.setWidth(width);
        column.setPreferredWidth(width);
    }

    public static void setTableColumnEditor(JTable table, int columnIndex, TableCellEditor editor) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellEditor(editor);
    }

    public static void setTableColumnRenderer(JTable table, int columnIndex, TableCellRenderer editor) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellRenderer(editor);
    }

    public static TableCellRenderer newStringTableCellRenderer(final DefaultTableCellRenderer renderer, final int length, final boolean tooltip) {
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val;
                renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String val2 = val = renderer.getText();
                if (val.length() > length) {
                    val2 = val.substring(0, length - 3) + "...";
                }
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, val2, isSelected, hasFocus, row, column);
                if (tooltip) {
                    comp.setToolTipText(val);
                }
                return comp;
            }
        };
    }
}

