/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.action;

import jaxx.runtime.JAXXObject;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;

/**
 * Action de base à utiliser pour encapsuler toutes les actions du système.
 * <p/>
 * Ces actions seront chargées par des {@link ActionProvider} et des {@link ActionFactory}.
 *
 * @author chemit
 */
public abstract class MyAbstractAction extends AbstractAction {

    protected static org.apache.commons.logging.Log log = LogFactory.getLog(MyAbstractAction.class);

    private static final long serialVersionUID = -810023044364620841L;

    protected ActionEvent e;

    protected MyAbstractAction delegate;

    protected abstract String getPrefix();

    protected MyAbstractAction(String name) {
        super(name);
    }

    protected MyAbstractAction(MyAbstractAction delegate) {
        super((String) delegate.getValue(Action.NAME));
        this.delegate = delegate;
    }

    @Override
    public void actionPerformed(java.awt.event.ActionEvent e) {
        if (hasDelegate()) {
            // delegate to real action
            delegate.actionPerformed(e);
            return;
        }
        log.debug("------------------------------------------------------------");
        log.debug("event    : " + e);
        log.debug("source   : " + e.getSource());
        this.e = e;
        try {
            boolean accepted = beforeAction(e);
            log.debug("action   : " + this);
            if (accepted) {
                log.info(getActionName() + " (treate:" + accepted + ") : " + this);
            } else {
                log.debug(getActionName() + " (treate:" + accepted + ") : " + this);
            }
            if (accepted) {
                doAction(e);
                setStatus(_("jaxx.action.done", getName()));
                updateUI();
            }
        } catch (Exception e1) {
            showError(e1);
        } finally {
            this.e = null;
            // always clear action after use : actions are staless
            clear();
        }
    }

    public String getI18nToolTipText() {
        if (hasDelegate()) {
            return delegate.getI18nToolTipText();
        }
        return getPrefix() + ".action." + getActionName() + ".tooltip";
    }

    public void updateUI() {
        if (hasDelegate()) {
            delegate.updateUI();
        }
        // nothing by default
    }

    public void disposeUI() {
        if (hasDelegate()) {
            delegate.disposeUI();
        }
        // nothing by default
    }

    public MyAbstractAction getDelegate() {
        return delegate;
    }

    public boolean hasDelegate() {
        return delegate != null;
    }

    protected String getName() {
        return (String) getValue(NAME);
    }

    protected String getActionName() {
        return (String) getValue(ACTION_COMMAND_KEY);
    }

    protected void setStatus(String status) {
        // do nothing from here
        if (log.isDebugEnabled()) {
            log.debug(status);
        }
    }

    protected boolean beforeAction(ActionEvent evt) throws Exception {
        boolean canContinue = isEnabled();
        if (canContinue && hasDelegate()) {
            return delegate.beforeAction(evt);
        }
        return canContinue;
    }

    protected void doAction(ActionEvent evt) throws Exception {
        if (hasDelegate()) {
            delegate.doAction(evt);
        }
        // nothing by default
    }

    protected JComponent getUIObject(String name, JAXXObject container) {
        if (container == null) {
            return null;
        }
        return (JComponent) container.getObjectById(name);
    }

    protected void clear() {
        if (hasDelegate()) {
            delegate.clear();
        }
        // nothing by default
    }

    protected void showError(Exception e) {
        log.error(e);
    }

    // -----------------------------------------------------------------------------
    // --- super class delegate methods -------------------------------------------
    // -----------------------------------------------------------------------------

    @Override
    public Object getValue(String key) {
        if (hasDelegate()) {
            return delegate.getValue(key);
        }
        return super.getValue(key);
    }

    @Override
    public void putValue(String key, Object newValue) {
        if (hasDelegate()) {
            delegate.putValue(key, newValue);
        }
        super.putValue(key, newValue);
    }

    @Override
    public boolean isEnabled() {
        if (hasDelegate()) {
            return delegate.isEnabled();
        }
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (hasDelegate()) {
            delegate.setEnabled(newValue);
        }
        super.setEnabled(newValue);
    }

    @Override
    public Object[] getKeys() {
        if (hasDelegate()) {
            return getKeys();
        }
        return super.getKeys();
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (hasDelegate()) {
            delegate.firePropertyChange(propertyName, oldValue, newValue);
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (hasDelegate()) {
            delegate.addPropertyChangeListener(listener);
        }
        super.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (hasDelegate()) {
            delegate.removePropertyChangeListener(listener);
        }
        super.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (hasDelegate()) {
            return delegate.getPropertyChangeListeners();
        }
        return super.getPropertyChangeListeners();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        if (hasDelegate()) {
            return clone();
        }
        return super.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (hasDelegate()) {
            sb.append("[delegate: ").append(delegate.toString()).append("]");
        } else {
            sb.append("<key:").append(getActionName()).append(">");
        }
        return sb.toString();
    }
}
