package jaxx.runtime.css;

import jaxx.runtime.JAXXObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class Pseudoclasses {
    public static final String NO_PSEUDOCLASS = "no pseudoclass";

    private static Map<Object, Map<String, List<PropertyValue>>> properties = new WeakHashMap<Object, Map<String, List<PropertyValue>>>();


    private static class PropertyValue implements Comparable<PropertyValue> {
        private Object value;
        private int id;

        public PropertyValue(Object value, int id) {
            this.value = value;
            this.id = id;
        }

        public Object getValue() {
            return value;
        }

        public int getId() {
            return id;
        }

        public int compareTo(PropertyValue o) {
            return getId() - o.getId();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof PropertyValue)) {
                return false;
            }
            PropertyValue value = (PropertyValue) o;
            if (value.getId() != getId()) {
                return false;
            }
            if (value.getValue() == null) {
                return getValue() == null;
            }
            return value.getValue().equals(getValue());
        }

        @Override
        public int hashCode() {
            return (value != null ? value.hashCode() : 0) ^ id;
        }

        @Override
        public String toString() {
            return "PropertyValue[" + value + ", " + id + "]";
        }
    }

    private static List<PropertyValue> getPropertyList(Object object, String property) {
        Map<String, List<PropertyValue>> propertyMap = properties.get(object);
        if (propertyMap == null) {
            propertyMap = new HashMap<String, List<PropertyValue>>();
            properties.put(object, propertyMap);
        }

        List<PropertyValue> propertyList = propertyMap.get(property);
        if (propertyList == null) {
            propertyList = new ArrayList<PropertyValue>();
            propertyMap.put(property, propertyList);
        }

        return propertyList;
    }

    public static boolean isPropertyApplied(Object object, String property, int id) {
        for (PropertyValue aPropertyList : getPropertyList(object, property)) {
            if (aPropertyList.getId() == id) {
                return true;
            }
        }
        return false;
    }

    public static void propertyApplied(Object object, String property, Object value, int id) {
        List<PropertyValue> propertyList = getPropertyList(object, property);
        propertyList.add(new PropertyValue(value, id));
        Collections.sort(propertyList);
    }

    public static void propertyRemoved(Object object, String property, Object value, int id) {
        List<PropertyValue> propertyList = getPropertyList(object, property);
        propertyList.remove(new PropertyValue(value, id));
    }

    public static Object getCurrentValue(Object object, String property) {
        List<PropertyValue> propertyList = getPropertyList(object, property);
        if (propertyList.size() > 0) {
            return propertyList.get(propertyList.size() - 1).getValue();
        }
        return NO_PSEUDOCLASS;
    }

    public static Object applyProperty(JAXXObject parent, Object object, String property, Object newValue, Object currentValue, int id) {
        if (!isPropertyApplied(object, property, id)) {
            Object value = getCurrentValue(object, property);
            if (value == NO_PSEUDOCLASS) {
                propertyApplied(object, property, wrap(currentValue), -1);
            }
            propertyApplied(object, property, wrap(newValue), id);
            value = getCurrentValue(object, property);
            if (value instanceof DataBinding) {
                parent.applyDataBinding(((DataBinding) value).getId());
            }
            return value;
        } else
            return currentValue;
    }

    public static Object removeProperty(JAXXObject parent, Object object, String property, Object oldValue, Object currentValue, int id) {
        if (isPropertyApplied(object, property, id)) {
            Object value = getCurrentValue(object, property);
            if (value == NO_PSEUDOCLASS) {
                throw new IllegalStateException("found NO_PSEUDOCLASS value for a property which does not have a default value");
            }
            if (value instanceof DataBinding) {
                parent.removeDataBinding(((DataBinding) value).getId());
            }
            propertyRemoved(object, property, wrap(oldValue), id);
            value = getCurrentValue(object, property);
            return value;
        } else
            return currentValue;
    }

    public static Object wrap(boolean value) {
        return value;
    }

    public static Object wrap(byte value) {
        return value;
    }

    public static Object wrap(short value) {
        return value;
    }

    public static Object wrap(int value) {
        return value;
    }

    public static Object wrap(long value) {
        return value;
    }

    public static Object wrap(float value) {
        return value;
    }

    public static Object wrap(double value) {
        return value;
    }

    public static Object wrap(char value) {
        return value;
    }

    public static Object wrap(Object value) {
        return value;
    }
}