/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;


/**
 * A <code>PropertyChangeListener</code> which processes a data binding when it receives a
 * <code>PropertyChangeEvent</code>.
 */
public class DataBindingListener implements PropertyChangeListener {
    private JAXXObject object;
    private String dest;

    /**
     * Creates a new <code>DataBindingListener</code> which will run the given data binding
     * when it receives a <code>PropertyChangeEvent</code>.
     *
     * @param object the object in which the data binding exists
     * @param dest   the name of the data binding to run
     */
    public DataBindingListener(JAXXObject object, String dest) {
        this.object = object;
        this.dest = dest;
    }


    /**
     * Processes the data binding in response to a <code>PropertyChangeEvent</code>.
     *
     * @param e the event which triggered the binding
     */
    public void propertyChange(PropertyChangeEvent e) {
        object.processDataBinding(dest);

        // for now, handle dependency changes by always removing & reapplying
        // the binding.  We should be more efficient and only do this when it's
        // actually necessary
        object.removeDataBinding(dest);
        object.applyDataBinding(dest);
    }
}