/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.JAXXFactory;
import jaxx.compiler.beans.BeanInfoUtil;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.spi.Initializer;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.jaxx.plugin.AbstractJaxxMojo;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class GenerateMojo
extends AbstractJaxxMojo
implements CompilerConfiguration {
    private static final String[] INCLUDES = new String[]{"**/*.jaxx", "**/*.css"};
    @Parameter(property="jaxx.src", defaultValue="${basedir}/src/main/java")
    protected File src;
    @Parameter(property="jaxx.outJava", defaultValue="${basedir}/target/generated-sources/java")
    protected File outJava;
    @Parameter(property="jaxx.includes")
    protected String[] includes;
    @Parameter(property="jaxx.excludes")
    protected String[] excludes;
    @Parameter(property="jaxx.compilerFQN", defaultValue="jaxx.compiler.JAXXCompiler", required=true)
    protected String compilerFQN;
    @Parameter(property="jaxx.jaxxContextFQN", defaultValue="jaxx.runtime.context.DefaultJAXXContext", required=true)
    protected String jaxxContextFQN;
    @Parameter(property="jaxx.defaultErrorUIFQN")
    protected String defaultErrorUIFQN;
    @Parameter(property="jaxx.defaultDecoratorFQN", defaultValue="jaxx.compiler.decorators.DefaultCompiledObjectDecorator")
    protected String defaultDecoratorFQN;
    @Parameter(property="jaxx.addSourcesToClassPath", defaultValue="false")
    protected boolean addSourcesToClassPath;
    @Parameter(property="jaxx.addResourcesToClassPath", defaultValue="false")
    protected boolean addResourcesToClassPath;
    @Parameter(property="jaxx.addCompileClassPath", defaultValue="false")
    protected boolean addCompileClassPath;
    @Parameter(property="jaxx.addProjectClassPath", defaultValue="false")
    protected boolean addProjectClassPath;
    @Parameter(property="jaxx.testPhase", defaultValue="false")
    protected boolean testPhase;
    @Parameter(property="jaxx.i18nable", defaultValue="true")
    protected boolean i18nable;
    @Parameter(property="jaxx.optimize", defaultValue="false")
    protected boolean optimize;
    @Parameter(property="jaxx.autoRecurseInCss", defaultValue="true")
    protected boolean autoRecurseInCss;
    @Parameter(property="jaxx.addLogger", defaultValue="true")
    protected boolean addLogger;
    @Parameter(property="jaxx.resetAfterCompile", defaultValue="true")
    protected boolean resetAfterCompile;
    @Parameter(property="jaxx.beanInfoSearchPath")
    protected String[] beanInfoSearchPath;
    @Parameter(property="jaxx.extraImportList")
    protected String extraImportList;
    @Parameter(property="jaxx.useUIManagerForIcon", defaultValue="false")
    protected boolean useUIManagerForIcon;
    @Parameter(property="jaxx.profile", defaultValue="false")
    protected boolean profile;
    @Parameter(property="jaxx.showBinding", defaultValue="false")
    protected boolean showBinding;
    @Parameter(property="jaxx.helpBrokerFQN", defaultValue="jaxx.runtime.swing.help.JAXXHelpBroker")
    protected String helpBrokerFQN;
    @Parameter(property="jaxx.validatorFactoryFQN", defaultValue="jaxx.runtime.validator.swing.SwingValidator")
    protected String validatorFactoryFQN;
    @Parameter(property="jaxx.showClassDescriptorLoading", defaultValue="false")
    private boolean showClassDescriptorLoading;
    @Parameter(property="jaxx.addAutoHandlerUI", defaultValue="false")
    private boolean addAutoHandlerUI;
    @Parameter(property="jaxx.commonCss")
    private File commonCss;
    @Parameter(property="jaxx.cssExtension", defaultValue="css")
    private String cssExtension;
    @Component(role=CompiledObjectDecorator.class)
    protected Map<String, CompiledObjectDecorator> decorators;
    @Component(role=JAXXCompilerFinalizer.class)
    protected Map<String, JAXXCompilerFinalizer> finalizers;
    @Component(role=Initializer.class)
    protected Map<String, Initializer> initializers;
    protected String[] files;
    protected MirroredFileUpdater updater;
    private Class<?> defaultErrorUIClass;
    private Class<? extends CompiledObjectDecorator> defaultDecoratorClass;
    private Class<? extends JAXXContext> jaxxContextClass;
    private Class<? extends JAXXCompiler> compilerClass;
    private String[] extraImports;
    private boolean nofiles;
    protected ClassLoader cl;
    private JAXXEngine engine;

    public void init() throws Exception {
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.fixCompileSourceRoots();
        if (this.includes == null || this.includes.length == 0) {
            this.includes = INCLUDES;
        }
        this.updater = new AbstractJaxxMojo.JaxxFileUpdater(this.src, this.outJava);
        HashMap result = new HashMap();
        this.getFilesToTreateForRoots(this.includes, this.excludes, Arrays.asList(this.src.getAbsolutePath()), result, this.isForce() ? null : this.updater);
        this.files = (String[])result.get(this.src);
        if (this.files != null && this.files.length > 0) {
            HashSet<String> filterFiles = new HashSet<String>(this.files.length);
            for (String path : this.files) {
                if (path.endsWith(".css")) {
                    String string = path.substring(0, path.length() - 4) + ".jaxx";
                    File f = new File(this.src, string);
                    if (!f.exists()) continue;
                    if (this.isVerbose()) {
                        this.getLog().info((CharSequence)("will treate jaxx file from css " + f));
                    }
                    filterFiles.add(string);
                    continue;
                }
                if (!path.endsWith(".jaxx")) continue;
                filterFiles.add(path);
            }
            this.files = filterFiles.toArray(new String[filterFiles.size()]);
        }
        boolean bl = this.nofiles = this.files == null || this.files.length == 0;
        if (this.nofiles) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"No file to treate.");
            }
            return;
        }
        this.cl = this.initClassLoader(this.getProject(), this.src, this.addSourcesToClassPath, this.testPhase, this.addResourcesToClassPath, this.addCompileClassPath, this.addProjectClassPath);
        Thread.currentThread().setContextClassLoader(this.cl);
        this.compilerClass = Class.forName(this.compilerFQN, false, this.cl);
        this.defaultDecoratorClass = Class.forName(this.defaultDecoratorFQN, false, this.cl);
        this.jaxxContextClass = Class.forName(this.jaxxContextFQN, false, this.cl);
        if (!JAXXContext.class.isAssignableFrom(this.jaxxContextClass)) {
            throw new MojoExecutionException("jaxxContextFQN must be an implementation of " + JAXXContext.class + " but was : " + this.jaxxContextClass);
        }
        if (this.defaultErrorUIFQN != null && !this.defaultErrorUIFQN.trim().isEmpty()) {
            this.defaultErrorUIClass = Class.forName(this.defaultErrorUIFQN, false, this.cl);
        }
        if (this.beanInfoSearchPath != null && this.beanInfoSearchPath.length > 0) {
            BeanInfoUtil.addJaxxBeanInfoPath((String[])this.beanInfoSearchPath);
        }
        this.createDirectoryIfNecessary(this.getTargetDirectory());
        if (this.extraImportList != null && !this.extraImportList.isEmpty()) {
            Object[] imports = this.extraImportList.split(",");
            int i = 0;
            for (String string : imports) {
                imports[i++] = string.trim();
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("extra imports " + Arrays.toString(imports)));
            }
            this.extraImports = imports;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("includes : " + Arrays.toString(this.includes)));
            for (String file : this.files) {
                this.getLog().info((CharSequence)("will parse " + file));
            }
        }
    }

    protected boolean checkSkip() {
        if (this.nofiles) {
            this.getLog().info((CharSequence)"Nothing to generate - all files are up to date.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() throws Exception {
        this.getLog().info((CharSequence)("Detects " + this.files.length + " modified jaxx file(s). "));
        if (this.showBinding) {
            DataBindingHelper.SHOW_LOG = this.showBinding;
        }
        try {
            long t0 = System.nanoTime();
            JAXXFactory.setConfiguration((CompilerConfiguration)this);
            this.engine = JAXXFactory.newEngine((File)this.src, (String[])this.files);
            int nbFiles = this.engine.run();
            this.report(this.engine);
            if (nbFiles == -1) {
                throw new MojoExecutionException("Aborting due to errors reported by jaxxc");
            }
            String delay = PluginHelper.convertTime((long)(System.nanoTime() - t0));
            this.getLog().info((CharSequence)("Generated " + nbFiles + " file(s) in " + delay));
        }
        finally {
            DataBindingHelper.SHOW_LOG = false;
        }
    }

    @Override
    public File getTargetDirectory() {
        return this.outJava;
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.outJava = targetDirectory;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public boolean isAutoRecurseInCss() {
        return this.autoRecurseInCss;
    }

    public boolean isI18nable() {
        return this.i18nable;
    }

    public boolean isUseUIManagerForIcon() {
        return this.useUIManagerForIcon;
    }

    public boolean isAddLogger() {
        return this.addLogger;
    }

    public boolean isShowClassDescriptorLoading() {
        return this.showClassDescriptorLoading;
    }

    public boolean isAddAutoHandlerUI() {
        return this.addAutoHandlerUI;
    }

    public void setAddAutoHandlerUI(boolean addAutoHandlerUI) {
        this.addAutoHandlerUI = addAutoHandlerUI;
    }

    public Class<? extends JAXXContext> getJaxxContextClass() {
        return this.jaxxContextClass;
    }

    public String[] getExtraImports() {
        return this.extraImports;
    }

    public boolean isResetAfterCompile() {
        return this.resetAfterCompile;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public Class<?> getDefaultErrorUI() {
        return this.defaultErrorUIClass;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public Class<? extends JAXXCompiler> getCompilerClass() {
        return this.compilerClass;
    }

    public Class<? extends CompiledObjectDecorator> getDefaultDecoratorClass() {
        return this.defaultDecoratorClass;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isGenerateHelp() {
        return this.generateHelp;
    }

    public String getHelpBrokerFQN() {
        return this.helpBrokerFQN;
    }

    public String getValidatorFactoryFQN() {
        return this.validatorFactoryFQN;
    }

    public Map<String, CompiledObjectDecorator> getDecorators() {
        return this.decorators;
    }

    public Map<String, JAXXCompilerFinalizer> getFinalizers() {
        return this.finalizers;
    }

    public Map<String, Initializer> getInitializers() {
        return this.initializers;
    }

    public File getCommonCss() {
        return this.commonCss;
    }

    public String getCssExtension() {
        return this.cssExtension;
    }

    public JAXXEngine getEngine() {
        return this.engine;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    protected void fixCompileSourceRoots() {
        if (this.getProject() == null) {
            return;
        }
        if (this.testPhase) {
            this.addTestCompileSourceRoots(this.getTargetDirectory());
        } else {
            this.addCompileSourceRoots(this.getTargetDirectory());
        }
    }

    protected void report(JAXXEngine engine) {
        List errors;
        List warnings = engine.getWarnings();
        if (!warnings.isEmpty()) {
            StringBuilder buffer = new StringBuilder("JAXX detects " + (warnings.size() == 1 ? "1 warning" : warnings.size() + " warnings"));
            buffer.append(" :");
            for (String s : warnings) {
                buffer.append("\n").append(s);
            }
            this.getLog().warn((CharSequence)buffer.toString());
        }
        if (!(errors = engine.getErrors()).isEmpty()) {
            StringBuilder buffer = new StringBuilder("JAXX detects " + (errors.size() == 1 ? "1 error" : errors.size() + " errors"));
            buffer.append(" :");
            for (String s : errors) {
                buffer.append("\n").append(s);
            }
            this.getLog().error((CharSequence)buffer.toString());
        }
    }
}

