package org.nuiton.jaxx.demo.feature.validation.list;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableModel;
import org.nuiton.validator.bean.list.BeanListValidator;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class ListBeanValidationDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz28bRRTHx6ZOmoQmJSnlR4UI1CVA23XKgQNJQ9uEqokcWsUoioiQGHtf7UnHO8vMbLzh0AMHbvwDHLhyQf0fKk5IXLjmf0Dqn8B7u/ZuXNabbezD2H7z3me/783Mm/3jX1Yxmt1Quu14gbDKcw54GDo68KzogrN1d2/vYfMAWnYDTEsL3yrN4k+pzMr7bMZN7MYyZ7+OpFpMqhGp1ifV1lXXVx54J0ArdTZt7JEE0wGwln08MrhlTK2ReK6EfqD7z8pUnfWsv3++dVyCjV/LjIU+yp/DtK+/AiDN+lydlYVr2Xz9gB/ymuReG8Vp4bUxoQtkW5fcmK95F35gT9lknU34XCPMsptnKk+Ei1Chb9lMdQO66hH3QC5btv5yCi5OOo+B20CDc8ilcLkVOCmFsU4dh3vAvd3ETizfj+gTllW6ygVp2e1Xoj4C5Uv4hjclbFN8ypvquypt2fIJZmJ2mqgmppAu0rc7mEsxc6C10ukDMtJOiaaHK+E0aBzCbYMxvJ0pc7IaWbGcV0ftiJgauVHQVBJ7vro1WIt5Wvuw7xpbyenNxPcSCuERo9HSSkogH8veGoqLp2iGot5Oa5kEW3aFZB7g0XtilR8Hhs7WXiLvyv/k3aL/7w7LmeGuu+ninhP2yLKFIRX3Aos1IMcPEv9ZjbvgEAYhZL027FFWTzKsAw2fZWi4UD2R8DIZ36Ph08RhOl37lyucpHvDx8P80ailw+bhpM0jPcelfVbRAZpx2Uf3LWo9O+gVN52ro5sOPSZy/OnZU/1778XxoNNcRnGLp0WdaKp47H2tfNBWkLa5uM0EVsjaNvdX9tmUAYkdOeq4S/nKG31PVI8q3iCSQyTnATcdpFUmj5//efn7f15j5ftsWiru3ufkv8mmbEdjxZR0Q//LO5G413vncbxIMi2bkPxI4SZhs6u0MRebwnNxVdZCrNJSfpUSUc8evvjrt1+uPR9UqoQaq0Ui02pVvmUTwpPCg6gr9xtuZhee8Q0Erkq7aVZ/LdH3tN/vDZ9H4xeZ+TeVdkHT/O0woK+1KAP6dSeivFOE0gHR7mAV51fjLBa5xaukGVhYOyuVzKtj6qr08Ibr0PTW2SELPLBqXeOtATuq18BLIK7XCOT7RXRFF1ROcqdDTivPhwVknLMQ2pxUqoVUPM4hLI1N+KQQYSOnEtcLETZzNBQj5K1GMUJjLA2WXWwpGXS9B8DxSO8K6OUoullI0V6OoloBRbN0dnbAiB+jl5UxaZdaIGXcPPGt7SuPLk53LCaZv8upUhFVCxq7wkDUXSlVb0xR+DphBrwCVfsPqSScAf0MAAA=";
    private static final Log log = LogFactory.getLog(ListBeanValidationDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addIdentity;
    protected JXTable dataTable;
    protected JScrollPane dataTableScrollePane;
    protected JTable errorTable;
    protected SwingListValidatorMessageTableModel errorTableModel;
    protected ListBeanValidationDemoHandler handler;
    protected PeopleTableModel model;
    protected JButton ok;
    protected JButton removeIdentity;
    protected BeanListValidator<People> validator;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListBeanValidationDemo $DemoPanel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
            "ListBeanValidationDemo.css",
            "/org.nuiton.jaxx.demo.entities.People.java",
            "/org.nuiton.jaxx.demo.entities.People-error-validation.xml",
            "/org.nuiton.jaxx.demo.entities.People-info-validation.xml",
            "/org.nuiton.jaxx.demo.entities.People-warning-validation.xml",
            "ListBeanValidationDemoHandler.java",
            "PeopleTableModel.java"
        );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListBeanValidationDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ListBeanValidationDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListBeanValidationDemo() {
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ListBeanValidationDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addIdentity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addPeople();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, ok.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doActionPerformed__on__removeIdentity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removePeople();
    }

    public void doTableChanged__on__errorTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateOkEnabled();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddIdentity() {
        return addIdentity;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JScrollPane getDataTableScrollePane() {
        return dataTableScrollePane;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingListValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public ListBeanValidationDemoHandler getHandler() {
        return handler;
    }

    public PeopleTableModel getModel() {
        return model;
    }

    public JButton getOk() {
        return ok;
    }

    public JButton getRemoveIdentity() {
        return removeIdentity;
    }

    public BeanListValidator<People> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDataTableScrollePane() {
        dataTableScrollePane.getViewport().add(dataTable);
    }

    protected void createAddIdentity() {
        $objectMap.put("addIdentity", addIdentity = new JButton());
        
        addIdentity.setName("addIdentity");
        addIdentity.setText(t("jaxx.demo.action.add"));
        addIdentity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addIdentity"));
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setAutoCreateRowSorter(true);
    }

    protected void createDataTableScrollePane() {
        $objectMap.put("dataTableScrollePane", dataTableScrollePane = new JScrollPane());
        
        dataTableScrollePane.setName("dataTableScrollePane");
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setAutoCreateRowSorter(true);
        errorTable.setAutoResizeMode(2);
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setSelectionMode(0);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingListValidatorMessageTableModel());
        
        errorTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTableModel"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new PeopleTableModel());
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("jaxx.demo.action.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRemoveIdentity() {
        $objectMap.put("removeIdentity", removeIdentity = new JButton());
        
        removeIdentity.setName("removeIdentity");
        removeIdentity.setText(t("jaxx.demo.action.remove"));
        removeIdentity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeIdentity"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = BeanListValidator.newValidator(People.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new ListBeanValidationDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        createValidator();
        createErrorTableModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,120);
        $JPanel0.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel0,250);
        createDataTableScrollePane();
        createDataTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,3,0,0));
        createAddIdentity();
        createRemoveIdentity();
        createOk();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        SwingUtil.setComponentHeight($JPanel2,200);
        $JPanel2.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel2,500);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(dataTableScrollePane, BorderLayout.CENTER);
        addChildrenToDataTableScrollePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(addIdentity);
        $JPanel1.add(removeIdentity);
        $JPanel1.add(ok);
        // inline complete setup of $JPanel2
        $JPanel2.add($JScrollPane0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 8 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Form"));
        dataTable.setModel(model);
        $JPanel2.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorTable.setModel(errorTableModel);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}