package org.nuiton.jaxx.demo.component.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;

public class DateTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTVMTQRDtBBMg4TOUWOUJCxQ/d/UMpUhiVCqIJRwoc3GSHZLFyc46O2uWCwcP3vwDHrx6sfgPlCervHjlP1jFT7BnNslmQxIUc9idTL9+3f1m8vLtN6Q8AXe5qBmOb0vuGPskCAzhO9JuUGPj8e7uVmWfVmWBelVhu5ILCD+JJCTLkLU6+54Eo1xCJjNkMhWT2WIy87zhcoc6XUQrJch48oBRr06plHBzYHLV88ztDnIlcH3RqtW36361fn58cJKghc9JgMDF9udw7Dv/QBBNfakESduSkCvtk/fEZMSpYXPCdmo40KTayzPieS9Ig76DQxgtQdolAskk3LuQPJpOUwWuhOxSgTb4S+JQdl/C094RLAwa1TZbuNe0rRqVnmERSfV8BVzs4OKJhYlC8bmurpCWkGpwizIJZ9S9IPOmoovox5Y22r3nlFaB4TVROiPcVaDxDjZb5c6eXdMRCYuDTisk2CEVpgWf7uTPMFKhLK9JSmrZW1NvKnAuqtmVI2E+Bt+hgSzalFnxlNk9LhpEdtVRgStx0EQ3SO1djcdzSkKlmhpj3Zc4pYTLsfL5Oq2+XedBT6JsyR0lqsi1nvLUGRpPU31gEsxelc854rjiaUE9n0n1bTZ+ltNhRCXHJbrVgWQiSEegKJprRw+GcUzGUH1o5kKAGmAYz1Qc1k0k4Magm4g+ZUQ+FVlGogwp4eM23uLBFqlc7hWiQn9bHOxvqowGfjg6FF+bpydtUxvB5hbOy+ryb3QYV3CXCmmr3qZDR/OlzcxN4q6UYdyjDM1fm/vy8M63W0jsHruYVUyGYjKeEa+ObKnRk+Pv829+jUCyCBnGiVUkCv8cxmUd1a5zZgXuozXd3ERzDJ8zqk28VIwccLy4MLWKl5AsVGzHwh/EwwBVWh6uUqepo63TH18+XT9uK5XAHpf+JjNSK/Ua0rbDbIfqP4CWt/c1/KzrUd/ikXH3s/KEemfcljWu6ufa2fnV9rp65ANfvQq6e7Uq6tjMfzPcRoY/qbgRaQkIAAA=";
    private static final Log log = LogFactory.getLog(DateTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected JCheckBox dateEditableButton;
    protected DateTimeEditor editor;
    protected JCheckBox enableButton;
    protected JTextField formatConfig;
    protected JLabel formatConfigLabel;
    protected DateTimeEditorDemoHandler handler;
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected DateTimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultDate;
    protected JLabel resultDateLabel;
    protected JTextField resultDayDate;
    protected JLabel resultDayDateLabel;
    protected JTextField resultTimeDate;
    protected JLabel resultTimeDateLabel;
    protected JCheckBox timeEditableButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditorDemo $DemoPanel0;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo() {
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public JCheckBox getDateEditableButton() {
        return dateEditableButton;
    }

    public DateTimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JTextField getFormatConfig() {
        return formatConfig;
    }

    public JLabel getFormatConfigLabel() {
        return formatConfigLabel;
    }

    public DateTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public DateTimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultDate() {
        return resultDate;
    }

    public JLabel getResultDateLabel() {
        return resultDateLabel;
    }

    public JTextField getResultDayDate() {
        return resultDayDate;
    }

    public JLabel getResultDayDateLabel() {
        return resultDayDateLabel;
    }

    public JTextField getResultTimeDate() {
        return resultTimeDate;
    }

    public JLabel getResultTimeDateLabel() {
        return resultTimeDateLabel;
    }

    public JCheckBox getTimeEditableButton() {
        return timeEditableButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfigLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfig, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(dateEditableButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(timeEditableButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        result.add(resultDateLabel);
        result.add(resultDate);
        result.add(resultDayDateLabel);
        result.add(resultDayDate);
        result.add(resultTimeDateLabel);
        result.add(resultTimeDate);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
    }

    protected void createDateEditableButton() {
        $objectMap.put("dateEditableButton", dateEditableButton = new JCheckBox());
        
        dateEditableButton.setName("dateEditableButton");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new DateTimeEditor(this));
        
        editor.setName("editor");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected void createFormatConfig() {
        $objectMap.put("formatConfig", formatConfig = new JTextField());
        
        formatConfig.setName("formatConfig");
        formatConfig.setColumns(15);
    }

    protected void createFormatConfigLabel() {
        $objectMap.put("formatConfigLabel", formatConfigLabel = new JLabel());
        
        formatConfigLabel.setName("formatConfigLabel");
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DateTimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultDate() {
        $objectMap.put("resultDate", resultDate = new JTextField());
        
        resultDate.setName("resultDate");
        resultDate.setColumns(15);
    }

    protected void createResultDateLabel() {
        $objectMap.put("resultDateLabel", resultDateLabel = new JLabel());
        
        resultDateLabel.setName("resultDateLabel");
    }

    protected void createResultDayDate() {
        $objectMap.put("resultDayDate", resultDayDate = new JTextField());
        
        resultDayDate.setName("resultDayDate");
        resultDayDate.setColumns(15);
    }

    protected void createResultDayDateLabel() {
        $objectMap.put("resultDayDateLabel", resultDayDateLabel = new JLabel());
        
        resultDayDateLabel.setName("resultDayDateLabel");
    }

    protected void createResultTimeDate() {
        $objectMap.put("resultTimeDate", resultTimeDate = new JTextField());
        
        resultTimeDate.setName("resultTimeDate");
        resultTimeDate.setColumns(15);
    }

    protected void createResultTimeDateLabel() {
        $objectMap.put("resultTimeDateLabel", resultTimeDateLabel = new JLabel());
        
        resultTimeDateLabel.setName("resultTimeDateLabel");
    }

    protected void createTimeEditableButton() {
        $objectMap.put("timeEditableButton", timeEditableButton = new JCheckBox());
        
        timeEditableButton.setName("timeEditableButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new DateTimeEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createFormatConfigLabel();
        createFormatConfig();
        createDateEditableButton();
        createTimeEditableButton();
        createEnableButton();
        createEditor();
        createResult();
        createResultDateLabel();
        createResultDate();
        createResultDayDateLabel();
        createResultDayDate();
        createResultTimeDateLabel();
        createResultTimeDate();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}