/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JAXXBeanInfo.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.13/jaxx-compiler/src/main/java/jaxx/compiler/beans/JAXXBeanInfo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.beans;

import jaxx.compiler.reflect.ClassDescriptor;

/**
 * Mirrors the class <code>java.beans.BeanInfo</code>.  JAXX uses its own introspector rather than the built-in
 * <code>java.beans.Introspector</code> so that it can introspect {@link ClassDescriptor},
 * not just <code>java.lang.Class</code>.
 */
public class JAXXBeanInfo {

    private JAXXBeanDescriptor beanDescriptor;
    private JAXXPropertyDescriptor[] propertyDescriptors;
    private JAXXEventSetDescriptor[] eventSetDescriptors;

    public JAXXBeanInfo(JAXXBeanDescriptor beanDescriptor,
            JAXXPropertyDescriptor[] propertyDescriptors,
            JAXXEventSetDescriptor[] eventSetDescriptors) {
        this.beanDescriptor = beanDescriptor;
        this.propertyDescriptors = propertyDescriptors;
        this.eventSetDescriptors = eventSetDescriptors;
    }

    public JAXXBeanDescriptor getJAXXBeanDescriptor() {
        return beanDescriptor;
    }

    public JAXXPropertyDescriptor[] getJAXXPropertyDescriptors() {
        return propertyDescriptors;
    }

    public JAXXEventSetDescriptor[] getJAXXEventSetDescriptors() {
        return eventSetDescriptors;
    }
}
