/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateMissingRulesTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(GenerateMissingRulesTask.class);
    public static final String TASK_NAME = "GenerateMissingRules";

    public GenerateMissingRulesTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            String className = jaxxFile.getClassName();
            if (isVerbose) {
                log.info((Object)("start " + className));
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            if (compiler.isIdentCssFound()) {
                File cssFile = jaxxFile.getCssFile();
                String cssContent = FileUtils.readFileToString((File)cssFile);
                Map<String, CompiledObject> objects = compiler.getObjects();
                LinkedHashSet<String> cssRulesToAdd = new LinkedHashSet<String>();
                for (String id : objects.keySet()) {
                    Pattern classPattern;
                    Matcher classMatcher;
                    Pattern idPattern;
                    Matcher idMatcher;
                    CompiledObject object = objects.get(id);
                    String styleClass = object.getStyleClass();
                    if (isVerbose) {
                        log.info((Object)("id : " + id + ", styleClass : " + styleClass));
                    }
                    if (!id.startsWith("$") && !(idMatcher = (idPattern = Pattern.compile("#" + id + "\\s*\\{.*\\}", 32)).matcher(cssContent)).find()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("add css rule for #" + id + " in " + cssFile.getName()));
                        }
                        cssRulesToAdd.add("\n\n/* #" + id + " {} */");
                    }
                    if (styleClass == null || (classMatcher = (classPattern = Pattern.compile("\\." + styleClass + "\\s*\\{.*\\}", 32)).matcher(cssContent)).find()) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("add css rule for ." + styleClass + " in " + cssFile.getName()));
                    }
                    cssRulesToAdd.add("\n\n/* ." + styleClass + " {} */");
                }
                FileUtils.write((File)cssFile, (CharSequence)StringUtils.join(cssRulesToAdd, (String)""), (boolean)true);
            }
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

