/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.tags.TagHandler;
import jaxx.compiler.tags.swing.TableHandler;
import jaxx.compiler.types.TypeManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CellHandler
implements TagHandler {
    public static final String TAG_NAME = "cell";
    public static final String ATTRIBUTE_INSETS = "insets";
    public static final String ATTRIBUTE_WEIGHTX = "weightx";
    public static final String ATTRIBUTE_WEIGHTY = "weighty";
    public static final String ATTRIBUTE_COLUMNS = "columns";
    public static final String ATTRIBUTE_ROWS = "rows";
    public static final String ATTRIBUTE_FILL = "fill";
    public static final String ATTRIBUTE_ANCHOR = "anchor";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        Node parent = tag.getParentNode();
        if (parent.getNodeType() != 1 || !parent.getLocalName().equals("row")) {
            compiler.reportError("cell tag may only appear within row tag");
            return;
        }
        TableHandler.CompiledTable table = (TableHandler.CompiledTable)compiler.getOpenComponent();
        table.newCell();
        GridBagConstraints c = table.getCellConstraints();
        CellHandler.setAttributes(c, tag);
        this.compileChildrenSecondPass(tag, compiler);
    }

    public static void setAttribute(GridBagConstraints c, String name, String value) throws CompilerException {
        value = value.trim();
        if (name.equals(ATTRIBUTE_INSETS)) {
            c.insets = (Insets)TypeManager.convertFromString(value, Insets.class);
        } else if (name.equals(ATTRIBUTE_WEIGHTX)) {
            c.weightx = Double.parseDouble(value);
        } else if (name.equals(ATTRIBUTE_WEIGHTY)) {
            c.weighty = Double.parseDouble(value);
        } else if (name.equals(ATTRIBUTE_COLUMNS)) {
            c.gridwidth = Integer.parseInt(value);
        } else if (name.equals(ATTRIBUTE_ROWS)) {
            c.gridheight = Integer.parseInt(value);
        } else if (name.equals(ATTRIBUTE_FILL)) {
            Fill fill = Fill.valueOf(value);
            if (fill == null) {
                throw new CompilerException("invalid value for fill attribute: '" + value + "'");
            }
            c.fill = fill.getIntValue();
        } else if (name.equals(ATTRIBUTE_ANCHOR)) {
            Anchor anchor = Anchor.valueOf(value);
            if (anchor == null) {
                throw new CompilerException("invalid value for anchor attribute: '" + value + "'");
            }
            c.anchor = anchor.getIntValue();
        } else {
            throw new UnsupportedAttributeException(name);
        }
    }

    public static void setAttributes(GridBagConstraints c, Element tag) throws CompilerException {
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attribute = (Attr)children.item(i);
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            CellHandler.setAttribute(c, name, value);
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }

    static enum Fill {
        none(0),
        horizontal(2),
        vertical(3),
        both(1);

        private final int intValue;

        private Fill(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }
    }

    static enum Anchor {
        north(11),
        northeast(12),
        east(13),
        southeast(14),
        south(15),
        southwest(14),
        west(17),
        northwest(18),
        center(10);

        private final int intValue;

        private Anchor(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }
    }
}

