/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding.writers;

import java.util.List;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DataListener;
import jaxx.compiler.binding.writers.JAXXBindingWriter;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.JAXXBinding;

public abstract class AbstractJAXXBindingWriter<B extends JAXXBinding>
implements JAXXBindingWriter<B> {
    private final Class<B> type;
    protected boolean used;

    protected AbstractJAXXBindingWriter(Class<B> type) {
        this.type = type;
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    @Override
    public Class<B> getType() {
        return this.type;
    }

    @Override
    public void reset() {
        this.used = false;
    }

    protected abstract String getConstructorParams(DataBinding var1, DataListener[] var2);

    protected void writeInvocationMethod(DataBinding binding, DataListener[] trackers, JavaFileGenerator generator, StringBuilder buffer, List<JavaMethod> bMethods) {
        this.used = true;
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("registerDataBinding");
        buffer.append("(new ");
        buffer.append(this.getType().getSimpleName());
        buffer.append("(");
        buffer.append(this.getConstructorParams(binding, trackers));
        buffer.append(") {");
        buffer.append(eol);
        for (JavaMethod m : bMethods) {
            buffer.append(eol);
            String source = generator.generateMethod(m);
            buffer.append(JavaFileGenerator.indent(source, 4, false, eol));
            buffer.append(eol);
        }
        buffer.append("});").append(eol);
        if (binding.getInitDataBinding() != null) {
            buffer.append(binding.getInitDataBinding());
        }
    }
}

