/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.File;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.spi.Initializer;
import jaxx.compiler.tags.TagManager;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXXFactory {
    private static final Log log = LogFactory.getLog(JAXXFactory.class);
    protected static JAXXEngine engine;
    protected static CompilerConfiguration configuration;

    protected JAXXFactory() {
    }

    public static void setConfiguration(CompilerConfiguration configuration) {
        JAXXFactory.configuration = configuration;
    }

    public static JAXXEngine newDummyEngine() {
        return JAXXFactory.newEngine(null, new String[0]);
    }

    public static JAXXEngine newEngine(File basedir, String ... relativePaths) {
        JAXXFactory.checkConfiguration();
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
            throw new IllegalStateException("Since Jaxx 2.45, you need a Java 9+ JVM to 'generate' code !");
        }
        if (engine != null) {
            engine.reset(true);
        }
        engine = new JAXXEngine(configuration, basedir, relativePaths);
        return engine;
    }

    public static JAXXCompiler newDummyCompiler(ClassLoader classLoader) {
        JAXXCompiler compiler = new JAXXCompiler();
        if (classLoader != null) {
            compiler.setClassLoader(classLoader);
        }
        return compiler;
    }

    public static JAXXEngine getEngine() throws NullPointerException {
        JAXXFactory.checkConfiguration();
        JAXXFactory.checkEngine();
        return engine;
    }

    public static boolean isEngineRegistred() {
        return engine != null;
    }

    public static void initFactory() {
        JAXXFactory.checkConfiguration();
        TagManager.reset();
        boolean verbose = configuration.isVerbose();
        for (Initializer initializer : configuration.getInitializers().values()) {
            if (verbose) {
                log.info((Object)("load initializer " + initializer));
            }
            initializer.initialize();
        }
    }

    protected static void checkConfiguration() throws NullPointerException {
        if (configuration == null) {
            throw new NullPointerException("No configuration was registred.");
        }
    }

    protected static void checkEngine() throws NullPointerException {
        if (engine == null) {
            throw new NullPointerException("No engine was registred.");
        }
    }
}

