package org.nuiton.eugene.test2.beangen;

import java.beans.PropertyChangeListener;
 import java.beans.PropertyChangeSupport;
 import java.util.Collection;
 
public class Voiture {

    protected final PropertyChangeSupport pcs;
    public int immatriculation;
    public String modele;
    public PersonneDTO proprietaire;
    public Collection<Roue> roue;
    public Collection<Siege> siege;
    /**
     * Voiture :
     */
    public Voiture() {
        pcs = new PropertyChangeSupport(this);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * getImmatriculation :
     * @return int 
     */
    public int getImmatriculation() {
        return this.immatriculation;
    }

    /**
     * setImmatriculation :
     * @param newValue 
     */
    public void setImmatriculation(int newValue) {
        int oldValue = getImmatriculation();
        this.immatriculation = newValue;
        firePropertyChange("immatriculation", oldValue, newValue);
    }

    /**
     * getModele :
     * @return String 
     */
    public String getModele() {
        return this.modele;
    }

    /**
     * setModele :
     * @param newValue 
     */
    public void setModele(String newValue) {
        String oldValue = getModele();
        this.modele = newValue;
        firePropertyChange("modele", oldValue, newValue);
    }

    /**
     * getProprietaire :
     * @return PersonneDTO 
     */
    public PersonneDTO getProprietaire() {
        return this.proprietaire;
    }

    /**
     * setProprietaire :
     * @param newValue 
     */
    public void setProprietaire(PersonneDTO newValue) {
        PersonneDTO oldValue = getProprietaire();
        this.proprietaire = newValue;
        firePropertyChange("proprietaire", oldValue, newValue);
    }

    /**
     * getRoue :
     * @param index 
     * @return Roue 
     */
    public Roue getRoue(int index) {
        Roue o = getChild(roue, index);
        return o;
    }

    /**
     * addRoue :
     * @param roue 
     * @return Roue 
     */
    public Roue addRoue(Roue roue) {
        getRoue().add(roue);
        firePropertyChange("roue", null, roue);
        return roue;
    }

    /**
     * removeRoue :
     * @param roue 
     * @return boolean 
     */
    public boolean removeRoue(Roue roue) {
        boolean  removed = getRoue().remove(roue);
        if (removed) {
            firePropertyChange("roue", roue, null);
        }
        return removed;
    }

    /**
     * getRoue :
     * @return Collection<Roue> 
     */
    public Collection<Roue> getRoue() {
        return this.roue;
    }

    /**
     * setRoue :
     * @param newValue 
     */
    public void setRoue(Collection<Roue> newValue) {
        Collection<Roue> oldValue = getRoue();
        this.roue = newValue;
        firePropertyChange("roue", oldValue, newValue);
    }

    /**
     * getSiege :
     * @param index 
     * @return Siege 
     */
    public Siege getSiege(int index) {
        Siege o = getChild(siege, index);
        return o;
    }

    /**
     * addSiege :
     * @param siege 
     * @return Siege 
     */
    public Siege addSiege(Siege siege) {
        getSiege().add(siege);
        firePropertyChange("siege", null, siege);
        return siege;
    }

    /**
     * removeSiege :
     * @param siege 
     * @return boolean 
     */
    public boolean removeSiege(Siege siege) {
        boolean  removed = getSiege().remove(siege);
        if (removed) {
            firePropertyChange("siege", siege, null);
        }
        return removed;
    }

    /**
     * getSiege :
     * @return Collection<Siege> 
     */
    public Collection<Siege> getSiege() {
        return this.siege;
    }

    /**
     * setSiege :
     * @param newValue 
     */
    public void setSiege(Collection<Siege> newValue) {
        Collection<Siege> oldValue = getSiege();
        this.siege = newValue;
        firePropertyChange("siege", oldValue, newValue);
    }

    /**
     * getChild :
     * @param childs 
     * @param index 
     * @return <T> T 
     */
    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }


} //Voiture
