package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesGeneratorUtil.java 1235 2013-03-29 23:36:59Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.6.3/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesGeneratorUtil.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;

/**
 * Utility class for pure java templates.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.6
 */
public class JavaTemplatesGeneratorUtil extends JavaGeneratorUtil {

    /**
     * Check if the given classifier has the
     * {@link JavaTemplatesStereoTypes#STEREOTYPE_BEAN} stereotype.
     *
     * @param classifier classifier to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see JavaTemplatesStereoTypes#STEREOTYPE_BEAN
     */
    public static boolean hasBeanStereotype(ObjectModelClassifier classifier) {
        return classifier.hasStereotype(JavaTemplatesStereoTypes.STEREOTYPE_BEAN);
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_NO_PCS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_NO_PCS
     * @since 2.3
     */
    public static String getNoPCSTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_NO_PCS, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_BEAN_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_BEAN_SUPER_CLASS
     * @since 2.3
     */
    public static String getBeanSuperClassTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_BEAN_SUPER_CLASS, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_SUPER_CLASS
     * @since 2.6.2
     */
    public static String getSimpleBeanSuperClassTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_SUPER_CLASS, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_INTERFACE}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_INTERFACE
     * @since 2.3
     */
    public static String getSimpleBeanGenerateInterfaceTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_INTERFACE, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_FACTORY}
     * tag value on the given model or classifier.
     *
     * @param model model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_FACTORY
     * @since 2.3
     */
    public static String getSimpleBeanGenerateFactoryTagValue(ObjectModel model) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_FACTORY, null, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS
     * @since 2.6.2
     */
    public static String getSimpleBeanInterfaceSuperClassTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanClassNamePrefixTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanClassNameSuffixTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanInterfaceNamePrefixTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX, classifier, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanInterfaceNameSuffixTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX, classifier, model);
        return value;
    }
}
