package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesTagValues.java 1388 2014-07-06 18:10:59Z tchemit $
 * $HeadURL: https://svn.nuiton.org/eugene/tags/eugene-2.12/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesTagValues.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.tagvalue.TagValueDefinition;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider;
import org.nuiton.eugene.models.tagvalue.TagValues;

/**
 * Defines all tag values managed by Java templates.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @plexus.component role="org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider" role-hint="eugene-java-templates"
 * @since 2.5.6
 */
public class JavaTemplatesTagValues extends TagValueDefinitionProvider {

    /**
     * Tag value to set if do not want any pcs (says PropertyChangeSupport in a generated bean).
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #isNoPCS(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.5.6
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            defaultValue = "true",
            documentation = "To specify to not generate any propertyChange " +
                            "code for a class or any class of a model")
    public static final String TAG_NO_PCS = "noPCS";

    /**
     * Tag value to use a super class for generated bean.
     * <p/>
     * If the bean needs Property change support (says you do not add the {@link #TAG_NO_PCS} on classifier or model,
     * then your class must provide evrything for it.
     * <p/>
     * More over, if you use some collections in your bean you must also define
     * two method named {@code getChild(Collection list, int index)} and
     * {@code getChild(List list, int index)}
     * <p/>
     * See new code to know minimum stuff to add in your class for this purpose.
     * <pre>
     * public abstract class AbstractBean implements Serializable {
     *
     *     private static final long serialVersionUID = 1L;
     *
     *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
     *
     *     public void addPropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(listener);
     *     }
     *
     *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(propertyName, listener);
     *     }
     *
     *     public void removePropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(listener);
     *     }
     *
     *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(propertyName, listener);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
     *         pcs.firePropertyChange(propertyName, oldValue, newValue);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object newValue) {
     *         firePropertyChange(propertyName, null, newValue);
     *     }
     *
     *     protected <T> T getChild(Collection<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     *
     *     protected <T> T getChild(List<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     * }
     * </pre>
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getBeanSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.5.6
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with bean generator)")
    public static final String TAG_BEAN_SUPER_CLASS = "beanSuperClass";

    /**
     * Tag value to use a super class for generated bean.
     * <p/>
     * If the bean needs Property change support (says you do not add the {@link #TAG_NO_PCS} on classifier or model,
     * then your class must provide evrything for it.
     * <p/>
     * More over, if you use some collections in your bean you must also define
     * two method named {@code getChild(Collection list, int index)} and
     * {@code getChild(List list, int index)}
     * <p/>
     * See new code to know minimum stuff to add in your class for this purpose.
     * <pre>
     * public abstract class AbstractBean implements Serializable {
     *
     *     private static final long serialVersionUID = 1L;
     *
     *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
     *
     *     public void addPropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(listener);
     *     }
     *
     *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(propertyName, listener);
     *     }
     *
     *     public void removePropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(listener);
     *     }
     *
     *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(propertyName, listener);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
     *         pcs.firePropertyChange(propertyName, oldValue, newValue);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object newValue) {
     *         firePropertyChange(propertyName, null, newValue);
     *     }
     *
     *     protected <T> T getChild(Collection<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     *
     *     protected <T> T getChild(List<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     * }
     * </pre>
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.5.6
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated simple bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_SUPER_CLASS = "simpleBeanSuperClass";

    /**
     * To add a prefix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To add a prefix on class name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX = "simpleBeanClassNamePrefix";

    /**
     * To add a prefix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To add a suffix on class name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX = "simpleBeanClassNameSuffix";

    /**
     * To generate an interface of each simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #isSimpleBeanGenerateInterface(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To generate an interface for each bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_GENERATE_INTERFACE = "simpleBeanGenerateInterface";

    /**
     * Tag value to use a super interface for generated interfaces on simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanInterfaceSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated interfaces " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS = "simpleBeanInterfaceSuperClass";

    /**
     * To add a prefix on the name of each generated interface of a simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanInterfaceNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To add a prefix on interface name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX = "simpleBeanInterfaceNamePrefix";

    /**
     * To add a prefix on the name of each generated interface of a simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanInterfaceNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To add a suffix on interface name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX = "simpleBeanInterfaceNameSuffix";

    /**
     * To generate a factory of generated simple beans.
     * <p/>
     * You must use it on the complete model.
     *
     * @see #isSimpleBeanGenerateFactory(ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class},
            documentation = "To generate a factory of simple bean.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_GENERATE_FACTORY = "simpleBeanGenerateFactory";

    /**
     * To generate a factory of generated simple beans.
     * <p/>
     * You must use it on the complete model.
     *
     * @see #isSimpleBeanGenerateDefaults(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.7.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To generate defaults class with simple operations on the type.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_GENERATE_DEFAULTS = "simpleBeanGenerateDefaults";

    /**
     * Tag value to use a super super-class for generated defaults class of a
     * simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanDefaultsSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.7.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated defaults classes" +
                            "for a bean or any bean of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS = "simpleBeanDefaultsSuperClass";

    /**
     * To add a prefix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.7.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To add a prefix on class name of generated defaults bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX = "simpleBeanDefaultsClassNamePrefix";

    /**
     * To add a suffix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see #getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
     * @since 2.6.2
     */
    @TagValueDefinition(
            target = {ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class},
            documentation = "To add a suffix on class name of generated defaults bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    public static final String TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX = "simpleBeanDefaultsClassNameSuffix";

    /**
     * Obtain the value of the {@link #TAG_NO_PCS} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_NO_PCS
     * @since 2.3
     */
    public static boolean isNoPCS(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = TagValues.findBooleanTagValue(JavaTemplatesTagValues.TAG_NO_PCS, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_BEAN_SUPER_CLASS} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_BEAN_SUPER_CLASS
     * @since 2.3
     */
    public static String getBeanSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_BEAN_SUPER_CLASS, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_SUPER_CLASS} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_SUPER_CLASS
     * @since 2.6.2
     */
    public static String getSimpleBeanSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_SUPER_CLASS, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_GENERATE_INTERFACE} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_GENERATE_INTERFACE
     * @since 2.3
     */
    public static boolean isSimpleBeanGenerateInterface(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = TagValues.findBooleanTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_INTERFACE, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_GENERATE_FACTORY} tag value on the given model or classifier.
     *
     * @param model model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_GENERATE_FACTORY
     * @since 2.7.2
     */
    public static boolean isSimpleBeanGenerateFactory(ObjectModel model) {
        boolean value = TagValues.findBooleanTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_FACTORY, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS
     * @since 2.6.2
     */
    public static String getSimpleBeanInterfaceSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanInterfaceNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanInterfaceNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_GENERATE_DEFAULTS} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_GENERATE_DEFAULTS
     * @since 2.7.2
     */
    public static boolean isSimpleBeanGenerateDefaults(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = TagValues.findBooleanTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_DEFAULTS, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS
     * @since 2.7.2
     */
    public static String getSimpleBeanDefaultsSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX
     * @since 2.7.2
     */
    public static String getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX, classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link #TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX} tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     * <p/>
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see #TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX
     * @since 2.6.2
     */
    public static String getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX, classifier, aPackage, model);
        if (StringUtils.isBlank(value)) {
            value = "s";
        }
        return value;
    }

}
