/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.phases;

import org.neo4j.cypher.internal.frontend.v3_3.Foldable;
import org.neo4j.cypher.internal.frontend.v3_3.Foldable$;
import org.neo4j.cypher.internal.frontend.v3_3.InternalException;
import org.neo4j.cypher.internal.frontend.v3_3.InternalException$;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_3.ast.UnresolvedCall;
import org.neo4j.cypher.internal.frontend.v3_3.notification.DeprecatedProcedureNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_3.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.v3_3.phases.BaseState;
import org.neo4j.cypher.internal.frontend.v3_3.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Condition;
import org.neo4j.cypher.internal.frontend.v3_3.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Phase;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Transformer;
import org.neo4j.cypher.internal.frontend.v3_3.phases.VisitorPhase;
import org.neo4j.cypher.internal.v3_3.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.v3_3.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.v3_3.logical.plans.ResolvedCall;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;

public final class ProcedureDeprecationWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static final ProcedureDeprecationWarnings$ MODULE$;

    static {
        new ProcedureDeprecationWarnings$();
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.class.process((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<Condition> postConditions() {
        return VisitorPhase.class.postConditions((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.class.transform((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.class.name((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.class.andThen((Transformer)this, other);
    }

    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.class.adds((Transformer)this, (Condition)condition);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findDeprecations(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1)new Serializable(internalNotificationLogger){
            public static final long serialVersionUID = 0L;
            private final InternalNotificationLogger eta$0$1$1;

            public final void apply(InternalNotification notification) {
                this.eta$0$1$1.log(notification);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    private Set<InternalNotification> findDeprecations(Statement statement) {
        return (Set)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)statement), (Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var10_12;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)A1).signature()) != null) {
                    QualifiedName name = procedureSignature.name();
                    Option option = procedureSignature.deprecationInfo();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String deprecatedBy = (String)some.x();
                        Serializable serializable = new Serializable(this, name, deprecatedBy, resolvedCall){
                            public static final long serialVersionUID = 0L;
                            private final QualifiedName name$1;
                            private final String deprecatedBy$1;
                            private final ResolvedCall x2$1;

                            public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                return new Tuple2((Object)seq.$plus((Object)new DeprecatedProcedureNotification(this.x2$1.position(), this.name$1.toString(), this.deprecatedBy$1)), (Object)None$.MODULE$);
                            }
                            {
                                this.name$1 = name$1;
                                this.deprecatedBy$1 = deprecatedBy$1;
                                this.x2$1 = x2$1;
                            }
                        };
                        return var10_12;
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already", InternalException$.MODULE$.$lessinit$greater$default$2());
                }
                Object object = function1.apply(x1);
                return var10_12;
            }

            public final boolean isDefinedAt(Object x1) {
                Option option;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                Object object = x1;
                boolean bl = object instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)object).signature()) != null && (option = procedureSignature.deprecationInfo()) instanceof Some ? true : object instanceof UnresolvedCall;
                return bl;
            }
        });
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String description() {
        return "find calls to deprecated procedures and generate warnings for them";
    }

    private ProcedureDeprecationWarnings$() {
        MODULE$ = this;
        Transformer.class.$init$((Transformer)this);
        Phase.class.$init$((Phase)this);
        VisitorPhase.class.$init$((VisitorPhase)this);
    }
}

