/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncMongoIterable;
import com.mongodb.internal.async.client.MappingAsyncBatchCursor;
import java.util.Collection;

class MappingIterable<U, V>
implements AsyncMongoIterable<V> {
    private final AsyncMongoIterable<U> iterable;
    private final Function<U, V> mapper;

    MappingIterable(AsyncMongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = Assertions.notNull("iterable", iterable);
        this.mapper = Assertions.notNull("mapper", mapper);
    }

    @Override
    public void first(final SingleResultCallback<V> callback) {
        Assertions.notNull("callback", callback);
        this.iterable.first(new SingleResultCallback<U>(){

            @Override
            public void onResult(U result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result == null) {
                    callback.onResult(null, null);
                } else {
                    callback.onResult(MappingIterable.this.mapper.apply(result), null);
                }
            }
        });
    }

    @Override
    public void forEach(final Block<? super V> block, final SingleResultCallback<Void> callback) {
        Assertions.notNull("block", block);
        Assertions.notNull("callback", callback);
        this.iterable.forEach(new Block<U>(){

            @Override
            public void apply(U t) {
                block.apply(MappingIterable.this.mapper.apply(t));
            }
        }, new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super V>> void into(final A target, final SingleResultCallback<A> callback) {
        Assertions.notNull("target", target);
        Assertions.notNull("callback", callback);
        this.iterable.forEach(new Block<U>(){

            @Override
            public void apply(U t) {
                target.add(MappingIterable.this.mapper.apply(t));
            }
        }, new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(target, null);
                }
            }
        });
    }

    @Override
    public <W> AsyncMongoIterable<W> map(Function<V, W> mapper) {
        return new MappingIterable<V, W>(this, mapper);
    }

    @Override
    public AsyncMongoIterable<V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public Integer getBatchSize() {
        return this.iterable.getBatchSize();
    }

    @Override
    public void batchCursor(final SingleResultCallback<AsyncBatchCursor<V>> callback) {
        Assertions.notNull("callback", callback);
        this.iterable.batchCursor(new SingleResultCallback<AsyncBatchCursor<U>>(){

            @Override
            public void onResult(AsyncBatchCursor<U> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new MappingAsyncBatchCursor(batchCursor, MappingIterable.this.mapper), null);
                }
            }
        });
    }

    AsyncMongoIterable<U> getMapped() {
        return this.iterable;
    }
}

