/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.authorization;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.authorization.AuthorizationProvider;

public class OrgAppInstallationAuthorizationProvider
extends GitHub.DependentAuthorizationProvider {
    private final String organizationName;
    private String authorization;
    @Nonnull
    private Instant validUntil = Instant.MIN;

    @BetaApi
    public OrgAppInstallationAuthorizationProvider(String organizationName, AuthorizationProvider authorizationProvider) {
        super(authorizationProvider);
        this.organizationName = organizationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncodedAuthorization() throws IOException {
        OrgAppInstallationAuthorizationProvider orgAppInstallationAuthorizationProvider = this;
        synchronized (orgAppInstallationAuthorizationProvider) {
            if (this.authorization == null || Instant.now().isAfter(this.validUntil)) {
                String token = this.refreshToken();
                this.authorization = String.format("token %s", token);
            }
            return this.authorization;
        }
    }

    private String refreshToken() throws IOException {
        GitHub gitHub = this.gitHub();
        GHAppInstallation installationByOrganization = gitHub.getApp().getInstallationByOrganization(this.organizationName);
        GHAppInstallationToken ghAppInstallationToken = installationByOrganization.createToken().create();
        this.validUntil = ghAppInstallationToken.getExpiresAt().toInstant().minus(Duration.ofMinutes(5L));
        return Objects.requireNonNull(ghAppInstallationToken.getToken());
    }
}

