/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.ws.rs.core.Application;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.platform.Platform;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.transaction.JtaTransactionManagerLookup;
import org.keycloak.util.JsonSerialization;

public abstract class KeycloakApplication
extends Application {
    private static final Logger logger = Logger.getLogger(KeycloakApplication.class);
    protected final PlatformProvider platform = Platform.getPlatform();
    private static KeycloakSessionFactory sessionFactory;

    public KeycloakApplication() {
        try {
            logger.debugv("PlatformProvider: {0}", (Object)this.platform.getClass().getName());
            this.loadConfig();
            this.platform.onStartup(this::startup);
            this.platform.onShutdown(this::shutdown);
        }
        catch (Throwable t) {
            this.platform.exit(t);
        }
    }

    protected void startup() {
        CryptoIntegration.init((ClassLoader)KeycloakApplication.class.getClassLoader());
        sessionFactory = this.createSessionFactory();
        final ExportImportManager[] exportImportManager = new ExportImportManager[1];
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession session) {
                DBLockManager dbLockManager = new DBLockManager(session);
                dbLockManager.checkForcedUnlock();
                DBLockProvider dbLock = dbLockManager.getDBLock();
                dbLock.waitForLock(DBLockProvider.Namespace.KEYCLOAK_BOOT);
                try {
                    exportImportManager[0] = KeycloakApplication.this.bootstrap();
                }
                finally {
                    dbLock.releaseLock();
                }
            }
        });
        if (exportImportManager[0].isRunExport()) {
            exportImportManager[0].runExport();
        }
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent(sessionFactory));
    }

    protected void shutdown() {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
    }

    protected ExportImportManager bootstrap() {
        final BootstrapState bootstrapState = new BootstrapState();
        logger.debug((Object)"bootstrap");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)sessionFactory.getProviderFactory(JtaTransactionManagerLookup.class);
                if (lookup != null && lookup.getTransactionManager() != null) {
                    try {
                        Transaction transaction = lookup.getTransactionManager().getTransaction();
                        logger.debugv("bootstrap current transaction? {0}", (Object)(transaction != null ? 1 : 0));
                        if (transaction != null) {
                            logger.debugv("bootstrap current transaction status? {0}", (Object)transaction.getStatus());
                        }
                    }
                    catch (SystemException e) {
                        throw new RuntimeException(e);
                    }
                }
                ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
                ExportImportManager exportImportManager = bootstrapState.exportImportManager = new ExportImportManager(session);
                bootstrapState.newInstall = applianceBootstrap.isNewInstall();
                if (bootstrapState.newInstall) {
                    if (!exportImportManager.isImportMasterIncluded()) {
                        applianceBootstrap.createMasterRealm();
                    }
                    exportImportManager.runImport();
                    KeycloakApplication.this.createTemporaryAdmin(session);
                }
            }
        });
        if (!bootstrapState.newInstall) {
            bootstrapState.exportImportManager.runImport();
        }
        this.importAddUser();
        return bootstrapState.exportImportManager;
    }

    protected abstract void createTemporaryAdmin(KeycloakSession var1);

    protected void loadConfig() {
        ServiceLoader<ConfigProviderFactory> loader = ServiceLoader.load(ConfigProviderFactory.class, KeycloakApplication.class.getClassLoader());
        try {
            ConfigProviderFactory factory = loader.iterator().next();
            logger.debugv("ConfigProvider: {0}", (Object)factory.getClass().getName());
            Config.init((Config.ConfigProvider)factory.create().orElseThrow(() -> new RuntimeException("Failed to load Keycloak configuration")));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("No valid ConfigProvider found");
        }
    }

    protected abstract KeycloakSessionFactory createSessionFactory();

    public static KeycloakSessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public void importRealm(RealmRepresentation rep, String from) {
        block13: {
            boolean exists = false;
            try (KeycloakSession session = sessionFactory.create();){
                session.getTransactionManager().begin();
                try {
                    RealmManager manager = new RealmManager(session);
                    if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                        ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                        exists = true;
                    }
                    if (manager.getRealmByName(rep.getRealm()) != null) {
                        ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                        exists = true;
                    }
                    if (!exists) {
                        RealmModel realm = manager.importRealm(rep);
                        ServicesLogger.LOGGER.importedRealm(realm.getName(), from);
                    }
                }
                catch (Throwable t) {
                    session.getTransactionManager().setRollbackOnly();
                    throw t;
                }
            }
            catch (Throwable t) {
                if (exists) break block13;
                ServicesLogger.LOGGER.unableToImportRealm(t, rep.getRealm(), from);
            }
        }
    }

    public void importAddUser() {
        File addUserFile;
        String configDir = System.getProperty("jboss.server.config.dir");
        if (configDir != null && (addUserFile = new File(configDir + File.separator + "keycloak-add-user.json")).isFile()) {
            List realms;
            ServicesLogger.LOGGER.imprtingUsersFrom(addUserFile);
            try {
                realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
            }
            catch (IOException e) {
                ServicesLogger.LOGGER.failedToLoadUsers(e);
                return;
            }
            for (RealmRepresentation realmRep : realms) {
                for (UserRepresentation userRep : realmRep.getUsers()) {
                    try {
                        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session -> {
                            RealmModel realm = session.realms().getRealmByName(realmRep.getRealm());
                            if (realm == null) {
                                ServicesLogger.LOGGER.addUserFailedRealmNotFound(userRep.getUsername(), realmRep.getRealm());
                            }
                            session.getContext().setRealm(realm);
                            UserProvider users = session.users();
                            if (users.getUserByUsername(realm, userRep.getUsername()) != null) {
                                ServicesLogger.LOGGER.notCreatingExistingUser(userRep.getUsername());
                            } else {
                                UserModel user = RepresentationToModel.createUser((KeycloakSession)session, (RealmModel)realm, (UserRepresentation)userRep);
                                ServicesLogger.LOGGER.addUserSuccess(userRep.getUsername(), realmRep.getRealm());
                            }
                        });
                    }
                    catch (ModelDuplicateException e) {
                        ServicesLogger.LOGGER.addUserFailedUserExists(userRep.getUsername(), realmRep.getRealm());
                    }
                    catch (Throwable t) {
                        ServicesLogger.LOGGER.addUserFailed(t, userRep.getUsername(), realmRep.getRealm());
                    }
                }
            }
            if (!addUserFile.delete()) {
                ServicesLogger.LOGGER.failedToDeleteFile(addUserFile.getAbsolutePath());
            }
        }
    }

    private static class BootstrapState {
        ExportImportManager exportImportManager;
        boolean newInstall;

        private BootstrapState() {
        }
    }
}

