/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.utils.JsonUtils;

public class OIDCAttributeMapperHelperTest {
    @Test
    public void testSplitClaimPath() {
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)""), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"a"), (Matcher)Matchers.contains((Object[])new String[]{"a"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"a.b"), (Matcher)Matchers.contains((Object[])new String[]{"a", "b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"a\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"a.b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"a\\\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"a\\", "b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"a\\\\\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"a\\.b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"c.a\\\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"c", "a\\", "b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"c.a\\\\\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"c", "a\\.b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"c\\\\\\.b.a\\\\\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"c\\.b", "a\\.b"}));
        MatcherAssert.assertThat((Object)JsonUtils.splitClaimPath((String)"c\\h\\.b.a\\\\\\.b"), (Matcher)Matchers.contains((Object[])new String[]{"ch.b", "a\\.b"}));
    }
}

