/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.reader.xmlschema.CollisionInfo;
import com.sun.tools.xjc.reader.xmlschema.Messages;
import com.sun.tools.xjc.reader.xmlschema.ParticleBinder;
import com.sun.tools.xjc.reader.xmlschema.RawTypeSetBuilder;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultParticleBinder
extends ParticleBinder {
    DefaultParticleBinder() {
    }

    @Override
    public void build(XSParticle p, Collection<XSParticle> forcedProps) {
        Checker checker = this.checkCollision(p, forcedProps);
        if (checker.hasNameCollision()) {
            CReferencePropertyInfo prop = new CReferencePropertyInfo(this.getCurrentBean().getBaseClass() == null ? "Content" : "Rest", true, false, false, (XSComponent)p, this.builder.getBindInfo((XSComponent)p).toCustomizationList(), p.getLocator(), false, false, false);
            RawTypeSetBuilder.build(p, false).addTo(prop);
            prop.javadoc = Messages.format("DefaultParticleBinder.FallbackJavadoc", checker.getCollisionInfo().toString());
            this.getCurrentBean().addProperty(prop);
        } else {
            new Builder(checker.markedParticles).particle(p);
        }
    }

    @Override
    public boolean checkFallback(XSParticle p) {
        return this.checkCollision(p, Collections.<XSParticle>emptyList()).hasNameCollision();
    }

    private Checker checkCollision(XSParticle p, Collection<XSParticle> forcedProps) {
        Checker checker = new Checker(forcedProps);
        CClassInfo superClass = this.getCurrentBean().getBaseClass();
        if (superClass != null) {
            checker.readSuperClass(superClass);
        }
        checker.particle(p);
        return checker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Builder
    implements XSTermVisitor {
        private final Map<XSParticle, String> markedParticles;
        private boolean insideOptionalParticle;

        Builder(Map<XSParticle, String> markedParticles) {
            this.markedParticles = markedParticles;
        }

        private boolean marked(XSParticle p) {
            return this.markedParticles.containsKey(p);
        }

        private String getLabel(XSParticle p) {
            return this.markedParticles.get(p);
        }

        public void particle(XSParticle p) {
            XSTerm t = p.getTerm();
            if (this.marked(p)) {
                BIProperty cust = BIProperty.getCustomization((XSComponent)p);
                CPropertyInfo prop = cust.createElementOrReferenceProperty(this.getLabel(p), false, p, RawTypeSetBuilder.build(p, this.insideOptionalParticle));
                DefaultParticleBinder.this.getCurrentBean().addProperty(prop);
            } else {
                assert (!p.isRepeated());
                boolean oldIOP = this.insideOptionalParticle;
                this.insideOptionalParticle |= p.getMinOccurs() == 0;
                t.visit((XSTermVisitor)this);
                this.insideOptionalParticle = oldIOP;
            }
        }

        public void elementDecl(XSElementDecl e) {
            assert (false);
        }

        public void wildcard(XSWildcard wc) {
            assert (false);
        }

        public void modelGroupDecl(XSModelGroupDecl decl) {
            this.modelGroup(decl.getModelGroup());
        }

        public void modelGroup(XSModelGroup mg) {
            boolean oldIOP = this.insideOptionalParticle;
            this.insideOptionalParticle |= mg.getCompositor() == XSModelGroup.CHOICE;
            for (XSParticle p : mg.getChildren()) {
                this.particle(p);
            }
            this.insideOptionalParticle = oldIOP;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Checker
    implements XSTermVisitor {
        private CollisionInfo collisionInfo = null;
        private final NameCollisionChecker cchecker = new NameCollisionChecker();
        private final Collection<XSParticle> forcedProps;
        private XSParticle outerParticle;
        public final Map<XSParticle, String> markedParticles = new HashMap<XSParticle, String>();
        private final Map<XSParticle, String> labelCache = new Hashtable<XSParticle, String>();

        Checker(Collection<XSParticle> forcedProps) {
            this.forcedProps = forcedProps;
        }

        boolean hasNameCollision() {
            return this.collisionInfo != null;
        }

        CollisionInfo getCollisionInfo() {
            return this.collisionInfo;
        }

        public void particle(XSParticle p) {
            if (DefaultParticleBinder.this.getLocalPropCustomization(p) != null || DefaultParticleBinder.this.builder.getLocalDomCustomization(p) != null) {
                this.check(p);
                this.mark(p);
                return;
            }
            XSTerm t = p.getTerm();
            if (p.isRepeated() && (t.isModelGroup() || t.isModelGroupDecl())) {
                this.mark(p);
                return;
            }
            if (this.forcedProps.contains(p)) {
                this.mark(p);
                return;
            }
            this.outerParticle = p;
            t.visit((XSTermVisitor)this);
        }

        public void elementDecl(XSElementDecl decl) {
            this.check(this.outerParticle);
            this.mark(this.outerParticle);
        }

        public void modelGroup(XSModelGroup mg) {
            if (mg.getCompositor() == XSModelGroup.Compositor.CHOICE && DefaultParticleBinder.this.builder.getGlobalBinding().isChoiceContentPropertyEnabled()) {
                this.mark(this.outerParticle);
                return;
            }
            for (XSParticle child : mg.getChildren()) {
                this.particle(child);
            }
        }

        public void modelGroupDecl(XSModelGroupDecl decl) {
            this.modelGroup(decl.getModelGroup());
        }

        public void wildcard(XSWildcard wc) {
            this.mark(this.outerParticle);
        }

        void readSuperClass(CClassInfo ci) {
            this.cchecker.readSuperClass(ci);
        }

        private void check(XSParticle p) {
            if (this.collisionInfo == null) {
                this.collisionInfo = this.cchecker.check(p);
            }
        }

        private void mark(XSParticle p) {
            this.markedParticles.put(p, this.computeLabel(p));
        }

        private String computeLabel(XSParticle p) {
            String label = this.labelCache.get(p);
            if (label == null) {
                label = DefaultParticleBinder.this.computeLabel(p);
                this.labelCache.put(p, label);
            }
            return label;
        }

        private final class NameCollisionChecker {
            private final List<XSParticle> particles = new ArrayList<XSParticle>();
            private final Map<String, CPropertyInfo> occupiedLabels = new HashMap<String, CPropertyInfo>();

            private NameCollisionChecker() {
            }

            CollisionInfo check(XSParticle p) {
                String label = Checker.this.computeLabel(p);
                if (this.occupiedLabels.containsKey(label)) {
                    return new CollisionInfo(label, p.getLocator(), this.occupiedLabels.get((Object)label).locator);
                }
                for (XSParticle jp : this.particles) {
                    if (this.check(p, jp)) continue;
                    return new CollisionInfo(label, p.getLocator(), jp.getLocator());
                }
                this.particles.add(p);
                return null;
            }

            private boolean check(XSParticle p1, XSParticle p2) {
                return !Checker.this.computeLabel(p1).equals(Checker.this.computeLabel(p2));
            }

            void readSuperClass(CClassInfo base) {
                while (base != null) {
                    for (CPropertyInfo p : base.getProperties()) {
                        this.occupiedLabels.put(p.getName(true), p);
                    }
                    base = base.getBaseClass();
                }
            }
        }
    }
}

