/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.tagexpression;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.platform.launcher.tagexpression.ParseStatus;
import org.junit.platform.launcher.tagexpression.Stack;
import org.junit.platform.launcher.tagexpression.TagExpression;
import org.junit.platform.launcher.tagexpression.Token;
import org.junit.platform.launcher.tagexpression.TokenWith;

class Operator {
    private final String representation;
    private final int precedence;
    private final int arity;
    private final Associativity associativity;
    private final TagExpressionCreator tagExpressionCreator;

    static Operator nullaryOperator(String representation, int precedence) {
        return new Operator(representation, precedence, 0, null, (expressions, operatorToken) -> ParseStatus.success());
    }

    static Operator unaryOperator(String representation, int precedence, Associativity associativity, Function<TagExpression, TagExpression> unaryExpression) {
        return new Operator(representation, precedence, 1, associativity, (expressions, operatorToken) -> {
            TokenWith rhs = (TokenWith)expressions.pop();
            if (operatorToken.isLeftOf(rhs.token)) {
                Token combinedToken = operatorToken.concatenate(rhs.token);
                expressions.push(new TokenWith<TagExpression>(combinedToken, (TagExpression)unaryExpression.apply((TagExpression)rhs.element)));
                return ParseStatus.success();
            }
            return ParseStatus.missingRhsOperand(operatorToken, representation);
        });
    }

    static Operator binaryOperator(String representation, int precedence, Associativity associativity, BiFunction<TagExpression, TagExpression, TagExpression> binaryExpression) {
        return new Operator(representation, precedence, 2, associativity, (expressions, operatorToken) -> {
            TokenWith rhs = (TokenWith)expressions.pop();
            TokenWith lhs = (TokenWith)expressions.pop();
            Token lhsToken = lhs.token;
            if (lhsToken.isLeftOf(operatorToken) && operatorToken.isLeftOf(rhs.token)) {
                Token combinedToken = lhsToken.concatenate(operatorToken).concatenate(rhs.token);
                expressions.push(new TokenWith<TagExpression>(combinedToken, (TagExpression)binaryExpression.apply((TagExpression)lhs.element, (TagExpression)rhs.element)));
                return ParseStatus.success();
            }
            if (rhs.token.isLeftOf(operatorToken)) {
                return ParseStatus.missingRhsOperand(operatorToken, representation);
            }
            if (operatorToken.isLeftOf(lhsToken)) {
                return ParseStatus.missingOperatorBetween(lhs, rhs);
            }
            return ParseStatus.problemParsing(operatorToken, representation);
        });
    }

    private Operator(String representation, int precedence, int arity, Associativity associativity, TagExpressionCreator tagExpressionCreator) {
        this.representation = representation;
        this.precedence = precedence;
        this.arity = arity;
        this.associativity = associativity;
        this.tagExpressionCreator = tagExpressionCreator;
    }

    boolean represents(String token) {
        return this.representation.equals(token);
    }

    String representation() {
        return this.representation;
    }

    boolean hasLowerPrecedenceThan(Operator operator) {
        return this.precedence < operator.precedence;
    }

    boolean hasSamePrecedenceAs(Operator operator) {
        return this.precedence == operator.precedence;
    }

    boolean isLeftAssociative() {
        return Associativity.Left == this.associativity;
    }

    ParseStatus createAndAddExpressionTo(Stack<TokenWith<TagExpression>> expressions, Token operatorToken) {
        if (expressions.size() < this.arity) {
            String message = this.createMissingOperandMessage(expressions, operatorToken);
            return ParseStatus.errorAt(operatorToken, this.representation, message);
        }
        return this.tagExpressionCreator.createExpressionAndAddTo(expressions, operatorToken);
    }

    private String createMissingOperandMessage(Stack<TokenWith<TagExpression>> expressions, Token operatorToken) {
        if (1 == this.arity) {
            return this.missingOneOperand(this.associativity == Associativity.Left ? "lhs" : "rhs");
        }
        if (2 == this.arity) {
            int mismatch = this.arity - expressions.size();
            if (2 == mismatch) {
                return "missing lhs and rhs operand";
            }
            return this.missingOneOperand(operatorToken.isLeftOf(expressions.peek().token) ? "lhs" : "rhs");
        }
        return "missing operand";
    }

    private String missingOneOperand(String side) {
        return "missing " + side + " operand";
    }

    static interface TagExpressionCreator {
        public ParseStatus createExpressionAndAddTo(Stack<TokenWith<TagExpression>> var1, Token var2);
    }

    static enum Associativity {
        Left,
        Right;

    }
}

