/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.value.config;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import org.apache.commons.lang3.builder.Builder;
import org.jtwig.util.builder.ListBuilder;
import org.jtwig.value.WrappedCollection;
import org.jtwig.value.compare.ValueComparator;
import org.jtwig.value.config.ValueConfiguration;
import org.jtwig.value.convert.Converter;
import org.jtwig.value.convert.string.StringConverter;

public class ValueConfigurationBuilder<B extends ValueConfigurationBuilder>
implements Builder<ValueConfiguration> {
    private MathContext mathContext;
    private RoundingMode roundingMode;
    private final ListBuilder<B, Converter<Boolean>> booleanConverters;
    private final ListBuilder<B, Converter<BigDecimal>> numberConverters;
    private final ListBuilder<B, Converter<WrappedCollection>> collectionConverters;
    private final ListBuilder<B, Converter<Character>> charConverters;
    private ValueComparator valueComparator;
    private StringConverter stringConverter;

    public ValueConfigurationBuilder() {
        this.booleanConverters = new ListBuilder(this.self());
        this.numberConverters = new ListBuilder(this.self());
        this.collectionConverters = new ListBuilder(this.self());
        this.charConverters = new ListBuilder(this.self());
    }

    public ValueConfigurationBuilder(ValueConfiguration prototype) {
        this.mathContext = prototype.getMathContext();
        this.roundingMode = prototype.getRoundingMode();
        this.valueComparator = prototype.getValueComparator();
        this.stringConverter = prototype.getStringConverter();
        this.booleanConverters = new ListBuilder<B, Converter<Boolean>>(this.self(), prototype.getBooleanConverters());
        this.numberConverters = new ListBuilder<B, Converter<BigDecimal>>(this.self(), prototype.getNumberConverters());
        this.collectionConverters = new ListBuilder<B, Converter<WrappedCollection>>(this.self(), prototype.getCollectionConverters());
        this.charConverters = new ListBuilder<B, Converter<Character>>(this.self(), prototype.getCharConverters());
    }

    public B withMathContext(MathContext mathContext) {
        this.mathContext = mathContext;
        return this.self();
    }

    public B withRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        return this.self();
    }

    public ListBuilder<B, Converter<Boolean>> booleanConverters() {
        return this.booleanConverters;
    }

    public ListBuilder<B, Converter<BigDecimal>> numberConverters() {
        return this.numberConverters;
    }

    public ListBuilder<B, Converter<WrappedCollection>> collectionConverters() {
        return this.collectionConverters;
    }

    public ListBuilder<B, Converter<Character>> charConverters() {
        return this.charConverters;
    }

    public B withValueComparator(ValueComparator valueComparator) {
        this.valueComparator = valueComparator;
        return this.self();
    }

    public B withStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
        return this.self();
    }

    private B self() {
        return (B)this;
    }

    public ValueConfiguration build() {
        return new ValueConfiguration(this.mathContext, this.roundingMode, (Collection<Converter<Boolean>>)this.booleanConverters.build(), (Collection<Converter<BigDecimal>>)this.numberConverters.build(), (Collection<Converter<WrappedCollection>>)this.collectionConverters.build(), (Collection<Converter<Character>>)this.charConverters.build(), this.valueComparator, this.stringConverter);
    }
}

