/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jtwig.render.context.Context;

public class RenderContext {
    private final Map<Class, Stack<Context<?>>> contexts;

    public static RenderContext create() {
        return new RenderContext(new HashMap());
    }

    public RenderContext(Map<Class, Stack<Context<?>>> contexts) {
        this.contexts = contexts;
    }

    public <T> RenderContext start(Class<T> type, T context) {
        if (!this.contexts.containsKey(type)) {
            this.contexts.put(type, new Stack());
        }
        this.contexts.get(type).push(Context.create(context));
        return this;
    }

    public <T> T end(Class<T> type) {
        if (!this.contexts.containsKey(type)) {
            throw new IllegalStateException(String.format("There is no context for %s", type));
        }
        Context<?> context = this.contexts.get(type).pop();
        context.end();
        return type.cast(context.getItem());
    }

    private <T> Context<T> getCurrentContext(Class<T> type) {
        if (!this.contexts.containsKey(type)) {
            throw new IllegalStateException(String.format("There is no context for %s", type));
        }
        return this.contexts.get(type).peek();
    }

    public <T> T getCurrent(Class<T> type) {
        return this.getCurrentContext(type).getItem();
    }

    public boolean hasCurrent(Class type) {
        return this.contexts.containsKey(type) && !this.contexts.get(type).isEmpty();
    }

    public void onEndCurrent(Class type, Runnable runnable) {
        this.getCurrentContext(type).onEnd(runnable);
    }

    public <T> void set(Class<T> type, T item) {
        this.getCurrentContext(type).set(item);
    }
}

