/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.parboiled.base;

import java.util.Collection;
import org.jtwig.parser.parboiled.ParserContext;
import org.jtwig.parser.parboiled.base.BasicParser;
import org.jtwig.parser.parboiled.model.Keyword;
import org.parboiled.Rule;
import org.parboiled.annotations.Label;

public class LexicParser
extends BasicParser<String> {
    final Collection<String> extraKeywords;
    Rule[] keywordRules = null;

    LexicParser(ParserContext context, Collection<String> extraKeywords) {
        super(LexicParser.class, context);
        this.extraKeywords = extraKeywords;
    }

    public Rule Identifier() {
        Rule identifier = this.Sequence(this.TestNot(this.Keyword()), this.Letter(), new Object[0]);
        if (this.keywordRules.length == 0) {
            identifier = this.Letter();
        }
        return this.Sequence(identifier, this.ZeroOrMore(this.LetterOrDigit()), new Object[0]);
    }

    @Label(value="Keywork")
    public Rule Keyword(Keyword keyword) {
        return this.Sequence(this.String(keyword.toString()), this.TestNot(this.LetterOrDigit()), new Object[0]);
    }

    @Label(value="Keywork")
    public Rule Keyword(String keyword) {
        return this.Sequence(this.String(keyword), this.TestNot(this.LetterOrDigit()), new Object[0]);
    }

    Rule Keyword() {
        return this.FirstOf(this.keywordRules());
    }

    Rule[] keywordRules() {
        Keyword[] keywords = Keyword.values();
        this.keywordRules = new Rule[keywords.length + this.extraKeywords.size()];
        for (int i = 0; i < keywords.length; ++i) {
            this.keywordRules[i] = this.Keyword(keywords[i]);
        }
        for (String extraKeyword : this.extraKeywords) {
            this.keywordRules[i++] = this.Keyword(extraKeyword);
        }
        return this.keywordRules;
    }

    public Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    public Rule LetterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_'), Character.valueOf('$')});
    }
}

