/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.KeyValuePair;
import org.jruby.util.TypeConverter;

public class Hash
extends Operand {
    public final KeyValuePair<Operand, Operand>[] pairs;
    public final boolean literal;

    public Hash(List<KeyValuePair<Operand, Operand>> pairs, boolean literal) {
        this(pairs.toArray(new KeyValuePair[pairs.size()]), literal);
    }

    protected Hash(KeyValuePair<Operand, Operand>[] pairs, boolean literal) {
        this.pairs = pairs;
        this.literal = literal;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.HASH;
    }

    public Hash(List<KeyValuePair<Operand, Operand>> pairs) {
        this(pairs, true);
    }

    public boolean isBlank() {
        return this.pairs == null || this.pairs.length == 0;
    }

    @Override
    public boolean hasKnownValue() {
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            if (pair.getKey().hasKnownValue() && pair.getValue().hasKnownValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        KeyValuePair[] newPairs = (KeyValuePair[])Arrays.stream(this.pairs).map(pair -> new KeyValuePair<Operand, Operand>(((Operand)pair.getKey()).getSimplifiedOperand(valueMap, force), ((Operand)pair.getValue()).getSimplifiedOperand(valueMap, force))).toArray(KeyValuePair[]::new);
        return new Hash(newPairs, this.literal);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            pair.getKey().addUsedVariables(l);
            pair.getValue().addUsedVariables(l);
        }
    }

    public Operand cloneForLVarDepth(int newDepth) {
        KeyValuePair[] newPairs = (KeyValuePair[])Arrays.stream(this.pairs).map(pair -> new KeyValuePair(pair.getKey(), ((DepthCloneable)pair.getValue()).cloneForDepth(newDepth))).toArray(KeyValuePair[]::new);
        return new Hash(newPairs, this.literal);
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        KeyValuePair[] newPairs = (KeyValuePair[])Arrays.stream(this.pairs).map(pair -> new KeyValuePair<Operand, Operand>(((Operand)pair.getKey()).cloneForInlining(ii), ((Operand)pair.getValue()).cloneForInlining(ii))).toArray(KeyValuePair[]::new);
        return new Hash(newPairs, this.literal);
    }

    public boolean isKeywordRest() {
        return this.pairs.length > 0 && this.pairs[0].getKey().equals(Symbol.KW_REST_ARG_DUMMY);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        RubyHash hash2;
        boolean smallHash;
        Ruby runtime2 = context.runtime;
        KeyValuePair<Operand, Operand>[] pairs = this.pairs;
        int index2 = 0;
        int length2 = pairs.length / 2;
        boolean bl = smallHash = length2 <= 10;
        if (this.isKeywordRest()) {
            IRubyObject rest = (IRubyObject)pairs[0].getValue().retrieve(context, self2, currScope, currDynScope, temp);
            TypeConverter.checkType(context, rest, context.runtime.getHash());
            hash2 = ((RubyHash)rest).dupFast(context);
            ++index2;
        } else {
            hash2 = smallHash ? RubyHash.newSmallHash(runtime2) : RubyHash.newHash(runtime2);
        }
        for (int i2 = index2; i2 < pairs.length; ++i2) {
            KeyValuePair<Operand, Operand> pair = pairs[i2];
            IRubyObject key2 = (IRubyObject)pair.getKey().retrieve(context, self2, currScope, currDynScope, temp);
            IRubyObject value2 = (IRubyObject)pair.getValue().retrieve(context, self2, currScope, currDynScope, temp);
            if (smallHash) {
                hash2.fastASetSmallCheckString(runtime2, key2, value2);
                continue;
            }
            hash2.fastASetCheckString(runtime2, key2, value2);
        }
        return hash2;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Hash(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.pairs.length);
        for (KeyValuePair<Operand, Operand> pair : this.pairs) {
            e.encode(pair.getKey());
            e.encode(pair.getValue());
        }
        e.encode(this.literal);
    }

    public static Hash decode(IRReaderDecoder d) {
        int size2 = d.decodeInt();
        KeyValuePair[] pairs = new KeyValuePair[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            pairs[i2] = new KeyValuePair<Operand, Operand>(d.decodeOperand(), d.decodeOperand());
        }
        return new Hash(pairs, d.decodeBoolean());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (!this.isBlank()) {
            int pairCount = this.pairs.length;
            for (int i2 = 0; i2 < pairCount; ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.pairs[i2]);
            }
        }
        builder.append("}");
        builder.append("(" + (this.literal ? "literal" : "keyword") + ")");
        return builder.toString();
    }

    public List<KeyValuePair<Operand, Operand>> getPairs() {
        return Arrays.asList(this.pairs);
    }
}

