/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.set;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Set"}, include={"Enumerable"})
public class RubySet
extends RubyObject
implements Set {
    RubyHash hash;
    private static final byte[] RECURSIVE_BYTES = new byte[]{46, 46, 46};

    static RubyClass createSetClass(Ruby runtime2) {
        RubyClass Set2 = runtime2.defineClass("Set", runtime2.getObject(), RubySet::new);
        Set2.setReifiedClass(RubySet.class);
        Set2.includeModule(runtime2.getEnumerable());
        Set2.defineAnnotatedMethods(RubySet.class);
        Set2.setMarshal(new SetMarshal(Set2.getMarshal()));
        runtime2.getLoadService().require("jruby/set.rb");
        return Set2;
    }

    void unmarshal() {
        this.hash = (RubyHash)this.getInstanceVariable("@hash");
    }

    protected RubySet(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    final void allocHash(Ruby runtime2) {
        this.setHash(new RubyHash(runtime2, runtime2.getFalse()));
    }

    final void allocHash(Ruby runtime2, int size2) {
        this.setHash(new RubyHash(runtime2, runtime2.getFalse(), size2));
    }

    final void setHash(RubyHash hash2) {
        this.hash = hash2;
        this.setInstanceVariable("@hash", hash2);
    }

    RubySet newSetFast(Ruby runtime2) {
        return RubySet.newSet(runtime2, this.getMetaClass());
    }

    public static RubySet newSet(Ruby runtime2) {
        return RubySet.newSet(runtime2, (RubyClass)runtime2.getClassFromPath("Set"));
    }

    public static RubySet newSet(Ruby runtime2, RubyClass metaclass) {
        RubySet set2 = new RubySet(runtime2, metaclass);
        set2.allocHash(runtime2);
        return set2;
    }

    private static RubySet newSet(ThreadContext context, RubyClass metaClass, RubyArray elements) {
        RubySet set2 = new RubySet(context.runtime, metaClass);
        return set2.initSet(context, elements.toJavaArrayMaybeUnsafe(), 0, elements.size());
    }

    final RubySet initSet(ThreadContext context, IRubyObject[] elements, int off, int len) {
        this.allocHash(context.runtime, Math.max(4, len));
        for (int i2 = off; i2 < len; ++i2) {
            this.invokeAdd(context, elements[i2]);
        }
        return this;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static RubySet create(ThreadContext context, IRubyObject self2, IRubyObject ... ary) {
        Ruby runtime2 = context.runtime;
        RubySet set2 = new RubySet(runtime2, (RubyClass)self2);
        return set2.initSet(context, ary, 0, ary.length);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        if (block.isGiven() && context.runtime.isVerbose()) {
            context.runtime.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        this.allocHash(context.runtime);
        return this;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject enume, Block block) {
        if (enume.isNil()) {
            return this.initialize(context, block);
        }
        if (block.isGiven()) {
            return this.initWithEnum(context, enume, block);
        }
        this.allocHash(context.runtime);
        return this.callMethod(context, "merge", enume);
    }

    protected IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.initialize(context, block);
            }
            case 1: {
                return this.initialize(context, args2[0], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    private IRubyObject initWithEnum(ThreadContext context, IRubyObject enume, final Block block) {
        if (enume instanceof RubyArray) {
            RubyArray ary = (RubyArray)enume;
            this.allocHash(context.runtime, ary.size());
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                this.invokeAdd(context, block.yield(context, (IRubyObject)ary.eltInternal(i2)));
            }
            return ary;
        }
        if (enume instanceof RubySet) {
            RubySet set2 = (RubySet)enume;
            this.allocHash(context.runtime, set2.size());
            for (IRubyObject elem : set2.elementsOrdered()) {
                this.invokeAdd(context, block.yield(context, elem));
            }
            return set2;
        }
        Ruby runtime2 = context.runtime;
        this.allocHash(runtime2);
        return RubySet.doWithEnum(context, enume, new EachBody(runtime2){

            @Override
            IRubyObject yieldImpl(ThreadContext context, IRubyObject val) {
                return RubySet.this.invokeAdd(context, block.yield(context, val));
            }
        });
    }

    private static IRubyObject doWithEnum(ThreadContext context, IRubyObject enume, EachBody blockImpl) {
        if (enume.respondsTo("each_entry")) {
            return enume.callMethod(context, "each_entry", IRubyObject.NULL_ARRAY, new Block(blockImpl));
        }
        if (enume.respondsTo("each")) {
            return enume.callMethod(context, "each", IRubyObject.NULL_ARRAY, new Block(blockImpl));
        }
        throw context.runtime.newArgumentError("value must be enumerable");
    }

    @Override
    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        if (this.getRuntime().newSymbol("@hash").equals(name2) && value2 instanceof RubyHash) {
            this.setHash((RubyHash)value2);
            return value2;
        }
        return super.instance_variable_set(name2, value2);
    }

    IRubyObject invokeAdd(ThreadContext context, IRubyObject val) {
        return this.callMethod(context, "add", val);
    }

    @JRubyMethod(frame=true)
    public IRubyObject initialize_dup(ThreadContext context, IRubyObject orig) {
        RubySet.sites((ThreadContext)context).initialize_dup_super.call(context, (IRubyObject)this, (IRubyObject)this, orig);
        this.setHash((RubyHash)((RubySet)orig).hash.dup(context));
        return this;
    }

    @JRubyMethod(frame=true, keywords=true, required=1, optional=1)
    public IRubyObject initialize_clone(ThreadContext context, IRubyObject[] args2) {
        RubySet.sites((ThreadContext)context).initialize_clone_super.call(context, (IRubyObject)this, (IRubyObject)this, args2);
        IRubyObject orig = args2[0];
        this.setHash((RubyHash)((RubySet)orig).hash.rbClone(context));
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject freeze(ThreadContext context) {
        RubyHash hash2 = this.hash;
        if (hash2 != null) {
            hash2.freeze(context);
        }
        return super.freeze(context);
    }

    @JRubyMethod(name={"size"}, alias={"length"})
    public IRubyObject length(ThreadContext context) {
        return context.runtime.newFixnum(this.size());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isEmpty());
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear(ThreadContext context) {
        this.modifyCheck(context.runtime);
        this.clearImpl();
        return this;
    }

    protected void clearImpl() {
        this.hash.rb_clear(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubySet replace(ThreadContext context, IRubyObject enume) {
        if (enume instanceof RubySet) {
            this.modifyCheck(context.runtime);
            this.clearImpl();
            this.addImplSet(context, (RubySet)enume);
        } else {
            Ruby runtime2 = context.runtime;
            if (!enume.getMetaClass().hasModuleInHierarchy(runtime2.getEnumerable()) && !enume.respondsTo("each_entry")) {
                throw runtime2.newArgumentError("value must be enumerable");
            }
            this.clearImpl();
            this.rb_merge(context, enume);
        }
        return this;
    }

    @Override
    @JRubyMethod
    public RubyArray to_a(ThreadContext context) {
        return this.hash.keys(context);
    }

    @JRubyMethod
    public RubySet to_set(ThreadContext context, Block block) {
        if (block.isGiven()) {
            RubySet set2 = new RubySet(context.runtime, this.getMetaClass());
            set2.initialize(context, this, block);
            return set2;
        }
        return this;
    }

    @JRubyMethod(rest=true)
    public RubySet to_set(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] rest;
        if (args2.length == 0) {
            return this.to_set(context, block);
        }
        IRubyObject klass = args2[0];
        Ruby runtime2 = context.runtime;
        RubyClass Set2 = runtime2.getClass("Set");
        if (klass == Set2 && args2.length == 1 & !block.isGiven()) {
            return this;
        }
        if (klass instanceof RubyClass) {
            rest = ArraySupport.newCopy(args2, 1, args2.length - 1);
        } else {
            klass = Set2;
            rest = args2;
        }
        RubySet set2 = new RubySet(context.runtime, (RubyClass)klass);
        set2.initialize(context, rest, block);
        return set2;
    }

    @JRubyMethod
    public IRubyObject compare_by_identity(ThreadContext context) {
        this.hash.compare_by_identity(context);
        return this;
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return this.hash.compare_by_identity_p(context);
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public RubySet flatten_merge(ThreadContext context, IRubyObject set2) {
        this.flattenMerge(context, set2, new IdentityHashMap());
        return this;
    }

    private void flattenMerge(ThreadContext context, IRubyObject set2, final IdentityHashMap seen) {
        if (set2 instanceof RubySet) {
            for (IRubyObject e : ((RubySet)set2).elementsOrdered()) {
                this.addFlattened(context, seen, e);
            }
        } else {
            set2.callMethod(context, "each", IRubyObject.NULL_ARRAY, new Block(new EachBody(context.runtime){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject e) {
                    RubySet.this.addFlattened(context, seen, e);
                    return context.nil;
                }
            }));
        }
    }

    private void addFlattened(ThreadContext context, IdentityHashMap seen, IRubyObject e) {
        if (e instanceof RubySet) {
            if (seen.containsKey(e)) {
                throw context.runtime.newArgumentError("tried to flatten recursive Set");
            }
            seen.put(e, null);
            this.flattenMerge(context, e, seen);
            seen.remove(e);
        } else {
            this.add(context, e);
        }
    }

    @JRubyMethod
    public RubySet flatten(ThreadContext context) {
        return this.newSetFast(context.runtime).flatten_merge(context, this);
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context) {
        for (IRubyObject e : this.elementsOrdered()) {
            if (!(e instanceof RubySet)) continue;
            return this.replace(context, this.flatten(context));
        }
        return context.nil;
    }

    @JRubyMethod(name={"include?"}, alias={"member?", "==="})
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, this.containsImpl(obj));
    }

    final boolean containsImpl(IRubyObject obj) {
        return this.hash.fastARef(obj) != null;
    }

    private boolean allElementsIncluded(RubySet set2) {
        for (IRubyObject o : set2.elements()) {
            if (this.containsImpl(o)) continue;
            return false;
        }
        return true;
    }

    @JRubyMethod(name={"superset?"}, alias={">="})
    public IRubyObject superset_p(ThreadContext context, IRubyObject set2) {
        if (set2 instanceof RubySet) {
            if (this.getMetaClass().isInstance(set2)) {
                return this.hash.op_ge(context, ((RubySet)set2).hash);
            }
            return RubyBoolean.newBoolean(context, this.size() >= ((RubySet)set2).size() && this.allElementsIncluded((RubySet)set2));
        }
        throw context.runtime.newArgumentError("value must be a set");
    }

    @JRubyMethod(name={"proper_superset?"}, alias={">"})
    public IRubyObject proper_superset_p(ThreadContext context, IRubyObject set2) {
        if (set2 instanceof RubySet) {
            if (this.getMetaClass().isInstance(set2)) {
                return this.hash.op_gt(context, ((RubySet)set2).hash);
            }
            return RubyBoolean.newBoolean(context, this.size() > ((RubySet)set2).size() && this.allElementsIncluded((RubySet)set2));
        }
        throw context.runtime.newArgumentError("value must be a set");
    }

    @JRubyMethod(name={"subset?"}, alias={"<="})
    public IRubyObject subset_p(ThreadContext context, IRubyObject set2) {
        if (set2 instanceof RubySet) {
            if (this.getMetaClass().isInstance(set2)) {
                return this.hash.op_le(context, ((RubySet)set2).hash);
            }
            return RubyBoolean.newBoolean(context, this.size() <= ((RubySet)set2).size() && this.allElementsIncluded((RubySet)set2));
        }
        throw context.runtime.newArgumentError("value must be a set");
    }

    @JRubyMethod(name={"proper_subset?"}, alias={"<"})
    public IRubyObject proper_subset_p(ThreadContext context, IRubyObject set2) {
        if (set2 instanceof RubySet) {
            if (this.getMetaClass().isInstance(set2)) {
                return this.hash.op_lt(context, ((RubySet)set2).hash);
            }
            return RubyBoolean.newBoolean(context, this.size() < ((RubySet)set2).size() && this.allElementsIncluded((RubySet)set2));
        }
        throw context.runtime.newArgumentError("value must be a set");
    }

    @JRubyMethod(name={"intersect?"})
    public IRubyObject intersect_p(ThreadContext context, IRubyObject set2) {
        if (set2 instanceof RubySet) {
            return RubyBoolean.newBoolean(context, this.intersect((RubySet)set2));
        }
        throw context.runtime.newArgumentError("value must be a set");
    }

    public boolean intersect(RubySet set2) {
        if (this.size() < set2.size()) {
            for (IRubyObject o : this.elementsOrdered()) {
                if (!set2.containsImpl(o)) continue;
                return true;
            }
        } else {
            for (IRubyObject o : set2.elementsOrdered()) {
                if (!this.containsImpl(o)) continue;
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(name={"disjoint?"})
    public IRubyObject disjoint_p(ThreadContext context, IRubyObject set2) {
        if (set2 instanceof RubySet) {
            return RubyBoolean.newBoolean(context, !this.intersect((RubySet)set2));
        }
        throw context.runtime.newArgumentError("value must be a set");
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubySet::size);
        }
        for (IRubyObject elem : this.elementsOrdered()) {
            block.yield(context, elem);
        }
        return this;
    }

    private static IRubyObject size(ThreadContext context, RubySet recv2, IRubyObject[] args2) {
        return context.runtime.newFixnum(recv2.size());
    }

    @JRubyMethod(name={"add"}, alias={"<<"})
    public RubySet add(ThreadContext context, IRubyObject obj) {
        this.modifyCheck(context.runtime);
        this.addImpl(context.runtime, obj);
        return this;
    }

    protected void addImpl(Ruby runtime2, IRubyObject obj) {
        this.hash.fastASetCheckString(runtime2, obj, runtime2.getTrue());
    }

    protected void addImplSet(ThreadContext context, RubySet set2) {
        this.hash.merge_bang(context, new IRubyObject[]{set2.hash}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"add?"})
    public IRubyObject add_p(ThreadContext context, IRubyObject obj) {
        if (this.containsImpl(obj)) {
            return context.nil;
        }
        return this.add(context, obj);
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject obj) {
        this.modifyCheck(context.runtime);
        this.deleteImpl(obj);
        return this;
    }

    protected boolean deleteImpl(IRubyObject obj) {
        this.hash.modify();
        return this.hash.fastDelete(obj);
    }

    protected void deleteImplIterator(IRubyObject obj, Iterator it) {
        it.remove();
    }

    @JRubyMethod(name={"delete?"})
    public IRubyObject delete_p(ThreadContext context, IRubyObject obj) {
        if (!this.containsImpl(obj)) {
            return context.nil;
        }
        return this.delete(context, obj);
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "delete_if", RubySet::size);
        }
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (!block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "keep_if", RubySet::size);
        }
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return this;
    }

    @JRubyMethod(name={"collect!"}, alias={"map!"})
    public IRubyObject collect_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "collect!", RubySet::size);
        }
        RubyArray elems = this.to_a(context);
        this.clearImpl();
        for (int i2 = 0; i2 < elems.size(); ++i2) {
            this.addImpl(context.runtime, block.yield(context, (IRubyObject)elems.eltInternal(i2)));
        }
        return this;
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "reject!", RubySet::size);
        }
        int size2 = this.size();
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (!block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return size2 == this.size() ? context.nil : this;
    }

    @JRubyMethod(name={"select!"}, alias={"filter!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select!", RubySet::size);
        }
        int size2 = this.size();
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return size2 == this.size() ? context.nil : this;
    }

    @JRubyMethod(name={"merge"})
    public RubySet rb_merge(ThreadContext context, IRubyObject enume) {
        Ruby runtime2 = context.runtime;
        if (enume instanceof RubySet) {
            this.modifyCheck(runtime2);
            this.addImplSet(context, (RubySet)enume);
        } else if (enume instanceof RubyArray) {
            this.modifyCheck(runtime2);
            RubyArray ary = (RubyArray)enume;
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                this.addImpl(runtime2, (IRubyObject)ary.eltInternal(i2));
            }
        } else {
            RubySet.doWithEnum(context, enume, new EachBody(runtime2){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject val) {
                    RubySet.this.addImpl(context.runtime, val);
                    return context.nil;
                }
            });
        }
        return this;
    }

    @JRubyMethod(name={"subtract"})
    public IRubyObject subtract(ThreadContext context, IRubyObject enume) {
        Ruby runtime2 = context.runtime;
        if (enume instanceof RubySet) {
            this.modifyCheck(runtime2);
            for (IRubyObject elem : ((RubySet)enume).elementsOrdered()) {
                this.deleteImpl(elem);
            }
        } else if (enume instanceof RubyArray) {
            this.modifyCheck(runtime2);
            RubyArray ary = (RubyArray)enume;
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                this.deleteImpl((IRubyObject)ary.eltInternal(i2));
            }
        } else {
            RubySet.doWithEnum(context, enume, new EachBody(runtime2){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject val) {
                    RubySet.this.deleteImpl(val);
                    return context.nil;
                }
            });
        }
        return this;
    }

    @JRubyMethod(name={"|"}, alias={"+", "union"})
    public IRubyObject op_or(ThreadContext context, IRubyObject enume) {
        return ((RubySet)this.dup()).rb_merge(context, enume);
    }

    @JRubyMethod(name={"-"}, alias={"difference"})
    public IRubyObject op_diff(ThreadContext context, IRubyObject enume) {
        return ((RubySet)this.dup()).subtract(context, enume);
    }

    @JRubyMethod(name={"&"}, alias={"intersection"})
    public IRubyObject op_and(ThreadContext context, IRubyObject enume) {
        final Ruby runtime2 = context.runtime;
        final RubySet newSet = new RubySet(runtime2, this.getMetaClass());
        if (enume instanceof RubySet) {
            newSet.allocHash(runtime2, ((RubySet)enume).size());
            for (IRubyObject obj : ((RubySet)enume).elementsOrdered()) {
                if (!this.containsImpl(obj)) continue;
                newSet.addImpl(runtime2, obj);
            }
        } else if (enume instanceof RubyArray) {
            RubyArray ary = (RubyArray)enume;
            newSet.allocHash(runtime2, ary.size());
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                Object obj = ary.eltInternal(i2);
                if (!this.containsImpl((IRubyObject)obj)) continue;
                newSet.addImpl(runtime2, (IRubyObject)obj);
            }
        } else {
            newSet.allocHash(runtime2);
            RubySet.doWithEnum(context, enume, new EachBody(runtime2){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject obj) {
                    if (RubySet.this.containsImpl(obj)) {
                        newSet.addImpl(runtime2, obj);
                    }
                    return context.nil;
                }
            });
        }
        return newSet;
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext context, IRubyObject enume) {
        Ruby runtime2 = context.runtime;
        RubySet newSet = new RubySet(runtime2, runtime2.getClass("Set"));
        newSet.initialize(context, enume, Block.NULL_BLOCK);
        for (IRubyObject o : this.elementsOrdered()) {
            if (newSet.containsImpl(o)) {
                newSet.deleteImpl(o);
                continue;
            }
            newSet.addImpl(runtime2, o);
        }
        return newSet;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (this.getMetaClass().isInstance(other)) {
            return this.hash.op_equal(context, ((RubySet)other).hash);
        }
        if (other instanceof RubySet) {
            RubySet that = (RubySet)other;
            if (this.size() == that.size()) {
                for (IRubyObject obj : this.elementsOrdered()) {
                    if (that.containsImpl(obj)) continue;
                    return context.fals;
                }
                return context.tru;
            }
        }
        return context.fals;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset(ThreadContext context) {
        this.hash.rehash(context);
        return this;
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        if (other instanceof RubySet) {
            return this.hash.op_eql(context, ((RubySet)other).hash);
        }
        return context.fals;
    }

    @Override
    public boolean eql(IRubyObject other) {
        if (other instanceof RubySet) {
            Ruby runtime2 = this.getRuntime();
            return this.hash.op_eql(runtime2.getCurrentContext(), ((RubySet)other).hash) == runtime2.getTrue();
        }
        return false;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.hash.hash();
    }

    @JRubyMethod(name={"classify"})
    public IRubyObject classify(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "classify", RubySet::size);
        }
        Ruby runtime2 = context.runtime;
        RubyHash h = new RubyHash(runtime2, this.size());
        for (IRubyObject i2 : this.elementsOrdered()) {
            IRubyObject key2 = block.yield(context, i2);
            IRubyObject set2 = h.fastARef(key2);
            if (set2 == null) {
                set2 = this.newSetFast(runtime2);
                h.fastASet(key2, set2);
            }
            ((RubySet)set2).invokeAdd(context, i2);
        }
        return h;
    }

    @JRubyMethod(name={"divide"})
    public IRubyObject divide(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "divide", RubySet::size);
        }
        if (block.getSignature().arityValue() == 2) {
            return this.divideTSort(context, block);
        }
        Ruby runtime2 = context.runtime;
        RubyHash vals = (RubyHash)this.classify(context, block);
        RubySet set2 = new RubySet(runtime2, runtime2.getClass("Set"));
        set2.allocHash(runtime2, vals.size());
        for (IRubyObject val : vals.directValues()) {
            set2.invokeAdd(context, val);
        }
        return set2;
    }

    private IRubyObject divideTSort(ThreadContext context, Block block) {
        final Ruby runtime2 = context.runtime;
        DivideTSortHash dig2 = DivideTSortHash.newInstance(context);
        for (IRubyObject u : this.elementsOrdered()) {
            RubyArray a = runtime2.newArray();
            dig2.fastASet(u, a);
            for (IRubyObject v : this.elementsOrdered()) {
                IRubyObject ret = block.call(context, u, v);
                if (!ret.isTrue()) continue;
                a.append(v);
            }
        }
        final RubyClass Set2 = runtime2.getClass("Set");
        final RubySet set2 = new RubySet(runtime2, Set2);
        set2.allocHash(runtime2, dig2.size());
        dig2.callMethod(context, "each_strongly_connected_component", IRubyObject.NULL_ARRAY, new Block(new JavaInternalBlockBody(runtime2, Signature.ONE_REQUIRED){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                return this.doYield(context, null, args2[0]);
            }

            @Override
            protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject css) {
                set2.addImpl(runtime2, RubySet.newSet(context, Set2, (RubyArray)css));
                return context.nil;
            }
        }));
        return set2;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        int otherSize;
        if (!(other instanceof RubySet)) {
            return context.nil;
        }
        RubySet otherSet = (RubySet)other;
        int size2 = this.size();
        if (size2 < (otherSize = otherSet.size())) {
            if (RubySet.sites((ThreadContext)context).proper_subset.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue()) {
                return RubyFixnum.minus_one(context.runtime);
            }
        } else if (size2 > otherSize) {
            if (RubySet.sites((ThreadContext)context).proper_superset.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue()) {
                return RubyFixnum.one(context.runtime);
            }
        } else if (RubySet.sites((ThreadContext)context).op_equal.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue()) {
            return RubyFixnum.zero(context.runtime);
        }
        return context.nil;
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join(ThreadContext context, IRubyObject sep) {
        return RubySet.sites((ThreadContext)context).ary_join.call(context, (IRubyObject)this, RubySet.sites((ThreadContext)context).to_a.call(context, this, this), sep);
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join(ThreadContext context) {
        return this.join(context, context.nil);
    }

    static RubyModule getTSort(Ruby runtime2) {
        if (!runtime2.getObject().hasConstant("TSort")) {
            runtime2.getLoadService().require("tsort");
        }
        return runtime2.getModule("TSort");
    }

    @Override
    public final IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"}, alias={"to_s"})
    public RubyString inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (this.size() == 0) {
            return this.inspectEmpty(runtime2);
        }
        if (runtime2.isInspecting(this)) {
            return this.inspectRecurse(runtime2);
        }
        RubyString str = RubyString.newStringLight(runtime2, 32, (Encoding)USASCIIEncoding.INSTANCE);
        RubySet.inspectPrefix(str, this.getMetaClass());
        try {
            runtime2.registerInspecting(this);
            this.inspectSet(context, str);
            RubyString rubyString = str.cat(62);
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    private RubyString inspectEmpty(Ruby runtime2) {
        RubyString str = RubyString.newStringLight(runtime2, 16, (Encoding)USASCIIEncoding.INSTANCE);
        RubySet.inspectPrefix(str, this.getMetaClass());
        str.cat(123).cat(125).cat(62);
        return str;
    }

    private RubyString inspectRecurse(Ruby runtime2) {
        RubyString str = RubyString.newStringLight(runtime2, 20, (Encoding)USASCIIEncoding.INSTANCE);
        RubySet.inspectPrefix(str, this.getMetaClass());
        str.cat(123).cat(RECURSIVE_BYTES).cat(125).cat(62);
        return str;
    }

    private static RubyString inspectPrefix(RubyString str, RubyClass metaClass) {
        str.cat(35).cat(60).cat(metaClass.getRealClass().getName().getBytes(RubyEncoding.UTF8));
        str.cat(58).cat(32);
        return str;
    }

    private void inspectSet(ThreadContext context, RubyString str) {
        str.cat((byte)123);
        boolean notFirst = false;
        for (IRubyObject elem : this.elementsOrdered()) {
            RubyString s2 = RubySet.inspect(context, elem);
            if (notFirst) {
                str.cat((byte)44).cat((byte)32);
            } else {
                str.setEncoding(s2.getEncoding());
            }
            notFirst = true;
            str.cat19(s2);
        }
        str.cat((byte)125);
    }

    protected final Set<IRubyObject> elements() {
        return this.hash.directKeySet();
    }

    protected Set<IRubyObject> elementsOrdered() {
        return this.elements();
    }

    protected final void modifyCheck(Ruby runtime2) {
        if ((this.flags & FROZEN_F) != 0) {
            throw runtime2.newFrozenError("Set", this);
        }
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    @Override
    public void clear() {
        this.clearImpl();
    }

    @Override
    public boolean contains(Object o) {
        return this.containsImpl(this.toRuby(o));
    }

    public Iterator<IRubyObject> rawIterator() {
        return this.elementsOrdered().iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.hash.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array2 = new Object[this.size()];
        int i2 = 0;
        for (IRubyObject elem : this.elementsOrdered()) {
            array2[i2++] = elem.toJava(Object.class);
        }
        return array2;
    }

    @Override
    public Object[] toArray(Object[] ary) {
        Class<?> type2 = ary.getClass().getComponentType();
        Object[] array2 = ary;
        if (array2.length < this.size()) {
            array2 = (Object[])Array.newInstance(type2, this.size());
        }
        int i2 = 0;
        for (IRubyObject elem : this.elementsOrdered()) {
            array2[i2++] = elem.toJava(type2);
        }
        return array2;
    }

    @Override
    public boolean add(Object element) {
        Ruby runtime2 = this.getRuntime();
        int size2 = this.size();
        this.addImpl(runtime2, RubySet.toRuby(runtime2, element));
        return this.size() > size2;
    }

    @Override
    public boolean remove(Object element) {
        return this.deleteImpl(this.toRuby(element));
    }

    @Override
    public boolean containsAll(Collection coll) {
        for (Object elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection coll) {
        Ruby runtime2 = this.getRuntime();
        int size2 = this.size();
        for (Object elem : coll) {
            this.addImpl(runtime2, RubySet.toRuby(runtime2, elem));
        }
        return this.size() > size2;
    }

    @Override
    public boolean retainAll(Collection coll) {
        int size2 = this.size();
        Iterator<IRubyObject> iter = this.rawIterator();
        while (iter.hasNext()) {
            IRubyObject elem = iter.next();
            if (coll.contains(elem.toJava(Object.class))) continue;
            this.deleteImplIterator(elem, iter);
        }
        return this.size() < size2;
    }

    @Override
    public boolean removeAll(Collection coll) {
        boolean removed = false;
        for (Object elem : coll) {
            removed = this.remove(elem) | removed;
        }
        return removed;
    }

    static IRubyObject toRuby(Ruby runtime2, Object obj) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, obj);
    }

    final IRubyObject toRuby(Object obj) {
        return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), obj);
    }

    @Override
    @Deprecated
    @JRubyMethod
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    @Deprecated
    @JRubyMethod
    public IRubyObject untaint(ThreadContext context) {
        return this;
    }

    private static JavaSites.SetSites sites(ThreadContext context) {
        return context.sites.Set;
    }

    public static final class DivideTSortHash
    extends RubyHash {
        private static final String NAME = "DivideTSortHash";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static DivideTSortHash newInstance(ThreadContext context) {
            Ruby runtime2 = context.runtime;
            RubyClass Set2 = runtime2.getClass("Set");
            RubyClass klass = (RubyClass)Set2.getConstantAt(NAME, true);
            if (klass != null) return new DivideTSortHash(runtime2, klass);
            Class<DivideTSortHash> clazz = DivideTSortHash.class;
            synchronized (DivideTSortHash.class) {
                klass = (RubyClass)Set2.getConstantAt(NAME, true);
                if (klass != null) return new DivideTSortHash(runtime2, klass);
                klass = Set2.defineClassUnder(NAME, runtime2.getHash(), runtime2.getHash().getAllocator());
                Set2.setConstantVisibility(runtime2, NAME, true);
                klass.includeModule(RubySet.getTSort(runtime2));
                klass.defineAnnotatedMethods(DivideTSortHash.class);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return new DivideTSortHash(runtime2, klass);
            }
        }

        DivideTSortHash(Ruby runtime2, RubyClass metaClass) {
            super(runtime2, metaClass);
        }

        @JRubyMethod
        public IRubyObject tsort_each_node(ThreadContext context, Block block) {
            return this.each_key(context, block);
        }

        @JRubyMethod
        public IRubyObject tsort_each_child(ThreadContext context, IRubyObject node, Block block) {
            IRubyObject set2 = this.fetch(context, node, Block.NULL_BLOCK);
            if (set2 instanceof RubySet) {
                return ((RubySet)set2).each(context, block);
            }
            return set2.callMethod(context, "each", IRubyObject.NULL_ARRAY, block);
        }
    }

    private static abstract class EachBody
    extends JavaInternalBlockBody {
        EachBody(Ruby runtime2) {
            super(runtime2, Signature.ONE_ARGUMENT);
        }

        @Override
        public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
            return this.yieldImpl(context, args2[0]);
        }

        abstract IRubyObject yieldImpl(ThreadContext var1, IRubyObject var2);

        @Override
        protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
            return this.yieldImpl(context, args2[0]);
        }

        @Override
        protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
            return this.yieldImpl(context, value2);
        }
    }

    private static final class SetMarshal
    implements ObjectMarshal {
        protected final ObjectMarshal defaultMarshal;

        SetMarshal(ObjectMarshal defaultMarshal) {
            this.defaultMarshal = defaultMarshal;
        }

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            this.defaultMarshal.marshalTo(runtime2, obj, type2, marshalStream);
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            Object result2 = this.defaultMarshal.unmarshalFrom(runtime2, type2, unmarshalStream);
            ((RubySet)result2).unmarshal();
            return result2;
        }
    }
}

