/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.io;

import com.headius.backport9.buffer.Buffers;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private boolean isOpen = true;
    private CharsetDecoder decoder;

    public WriterOutputStream(Writer writer) {
        this(writer, null);
    }

    public WriterOutputStream(Writer writer, String encoding2) {
        this.writer = writer;
        if (encoding2 == null && writer instanceof OutputStreamWriter) {
            encoding2 = ((OutputStreamWriter)writer).getEncoding();
        }
        if (encoding2 == null) {
            encoding2 = Charset.defaultCharset().name();
        } else if (!Charset.isSupported(encoding2)) {
            throw new IllegalArgumentException(encoding2 + " is not supported");
        }
        this.decoder = Charset.forName(encoding2).newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (!this.isOpen) {
                throw new IOException("This stream has been already closed.");
            }
            this.isOpen = false;
            this.decoder = null;
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (!this.isOpen) {
                return;
            }
            this.writer.flush();
        }
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] bb = new byte[]{(byte)b2};
        this.write(bb, 0, 1);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (!this.isOpen) {
                return;
            }
            if (off < 0 || len <= 0 || off + len > b2.length) {
                throw new IndexOutOfBoundsException();
            }
            ByteBuffer bytes2 = ByteBuffer.wrap(b2, off, len);
            CharBuffer chars2 = CharBuffer.allocate(len);
            this.byte2char(bytes2, chars2);
            char[] cbuf = new char[chars2.length()];
            chars2.get(cbuf, 0, chars2.length());
            this.writer.write(cbuf);
            this.writer.flush();
        }
    }

    private void byte2char(ByteBuffer bytes2, CharBuffer chars2) throws IOException {
        this.decoder.reset();
        Buffers.clearBuffer((Buffer)chars2);
        CoderResult result2 = this.decoder.decode(bytes2, chars2, true);
        if (result2.isError() || result2.isOverflow()) {
            throw new IOException(result2.toString());
        }
        if (result2.isUnderflow()) {
            Buffers.flipBuffer((Buffer)chars2);
        }
    }
}

