/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.clickhouse;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Records;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.XMLSchemaCollectionDefinition;
import org.jooq.meta.clickhouse.ClickHouseTableDefinition;
import org.jooq.meta.clickhouse.system.System;
import org.jooq.meta.clickhouse.system.tables.DataSkippingIndices;
import org.jooq.meta.clickhouse.system.tables.Tables;

public class ClickHouseDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        DataSkippingIndices i = System.SYSTEM.DATA_SKIPPING_INDICES;
        final Field columnName = DSL.field((Name)DSL.name((String)"column_name"), (DataType)SQLDataType.VARCHAR);
        final Field columnIndex = DSL.field((Name)DSL.name((String)"column_index"), (DataType)SQLDataType.INTEGER);
        Map indexes = this.create().select(i.DATABASE, i.TABLE, i.NAME, (SelectField)DSL.trim((Field)DSL.field((String)"c.1", (DataType)SQLDataType.VARCHAR)).as("column_name"), (SelectField)DSL.field((String)"c.2", (DataType)SQLDataType.INTEGER).as("column_index")).from("{0} array join arrayZip(splitByChar(',', expr), arrayEnumerate(splitByChar(',', expr))) as c", new QueryPart[]{i}).where(i.DATABASE.in(this.getInputSchemata())).fetchGroups(new Field[]{i.DATABASE, i.TABLE, i.NAME}, new Field[]{columnName, columnIndex});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(i.DATABASE));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(i.NAME);
            String tableName = (String)index.get(i.TABLE);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            for (Record column : columns) {
                if (table.getColumn((String)column.get(columnName)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(this, tableSchema, indexName, table, false){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(columnName)), SortOrder.ASC, (Integer)column.get(columnIndex)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        this.primaryKeys(this.getInputSchemata()).forEach(record -> {
            SchemaDefinition schema = this.getSchema((String)record.value2());
            if (schema != null) {
                String tableName = (String)record.value3();
                String key = (String)record.value4();
                String columnName = (String)record.value5();
                TableDefinition table = this.getTable(schema, tableName);
                if (table != null) {
                    relations2.addPrimaryKey(key, table, table.getColumn(columnName));
                }
            }
        });
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        Tables t = System.SYSTEM.TABLES;
        return this.create().select(t.DATABASE, t.DATABASE, t.NAME, (SelectField)DSL.inline((String)"KEY_").concat(new Field[]{t.NAME}).concat(new Field[]{DSL.inline((String)"_PRIMARY")}).as("constraint_name"), (SelectField)DSL.trim((Field)DSL.field((String)"c.1", (DataType)SQLDataType.VARCHAR)).as("column_name"), (SelectField)DSL.field((String)"c.2", (DataType)SQLDataType.INTEGER).as("column_index")).from("{0} array join arrayZip(splitByChar(',', primary_key), arrayEnumerate(splitByChar(',', primary_key))) as c", new QueryPart[]{t}).where(t.PRIMARY_KEY.ne((Object)"")).and(t.DATABASE.in(schemas));
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return null;
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return (List)this.create().select(org.jooq.meta.clickhouse.information_schema.Tables.SCHEMATA.SCHEMA_NAME).from((TableLike)org.jooq.meta.clickhouse.information_schema.Tables.SCHEMATA).collect(Collectors.mapping(r -> new SchemaDefinition((Database)this, (String)r.value1(), ""), Collectors.toList()));
    }

    @Override
    public ResultQuery<Record4<String, String, String, String>> sources(List<String> schemas) {
        return this.create().select((SelectField)System.SYSTEM.TABLES.DATABASE.as("catalog"), System.SYSTEM.TABLES.DATABASE, System.SYSTEM.TABLES.TABLE, System.SYSTEM.TABLES.CREATE_TABLE_QUERY).from((TableLike)System.SYSTEM.TABLES).where(System.SYSTEM.TABLES.DATABASE.in(schemas)).and(System.SYSTEM.TABLES.ENGINE.eq((Field)DSL.inline((String)"View")));
    }

    @Override
    public ResultQuery<Record5<String, String, String, String, String>> comments(List<String> schemas) {
        Table c = DSL.select((SelectField)System.SYSTEM.TABLES.DATABASE.as("catalog"), System.SYSTEM.TABLES.DATABASE, (SelectField)System.SYSTEM.TABLES.NAME.as(System.SYSTEM.COLUMNS.TABLE), (SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as(System.SYSTEM.COLUMNS.NAME), (SelectField)System.SYSTEM.TABLES.COMMENT.as(System.SYSTEM.COLUMNS.COMMENT)).from((TableLike)System.SYSTEM.TABLES).where(System.SYSTEM.TABLES.COMMENT.ne((Field)DSL.inline((String)""))).unionAll((Select)DSL.select((SelectField)System.SYSTEM.COLUMNS.DATABASE.as("catalog"), System.SYSTEM.COLUMNS.DATABASE, System.SYSTEM.COLUMNS.TABLE, System.SYSTEM.COLUMNS.NAME, System.SYSTEM.COLUMNS.COMMENT).from((TableLike)System.SYSTEM.COLUMNS).where(System.SYSTEM.COLUMNS.COMMENT.ne((Field)DSL.inline((String)"")))).asTable("c");
        return this.create().select((SelectField)c.field(System.SYSTEM.TABLES.DATABASE.as("catalog")), (SelectField)c.field(System.SYSTEM.TABLES.DATABASE), (SelectField)c.field(System.SYSTEM.COLUMNS.TABLE), (SelectField)c.field(System.SYSTEM.COLUMNS.NAME), (SelectField)c.field(System.SYSTEM.COLUMNS.COMMENT)).from((TableLike)c).where(c.field(System.SYSTEM.TABLES.DATABASE).in(schemas)).orderBy(new int[]{1, 2, 3, 4});
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return null;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> enums(List<String> schemas) {
        return null;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (TableRecord r : this.create().select(org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_SCHEMA, org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_NAME, (SelectField)DSL.when((Condition)org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_TYPE.in(new Field[]{DSL.inline((String)"VIEW"), DSL.inline((String)"SYSTEM VIEW")}), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).convertFrom(TableOptions.TableType::valueOf).as("table_type"), System.SYSTEM.TABLES.COMMENT).from((TableLike)org.jooq.meta.clickhouse.information_schema.Tables.TABLES).join((TableLike)System.SYSTEM.TABLES).on(org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_SCHEMA.eq(System.SYSTEM.TABLES.DATABASE)).and(org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_NAME.eq(System.SYSTEM.TABLES.NAME)).where(org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_SCHEMA, org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_NAME).fetch(Records.mapping(TableRecord::new))) {
            SchemaDefinition schema = this.getSchema(r.schema);
            if (schema == null) continue;
            result.add(new ClickHouseTableDefinition(schema, r.table, r.comment, r.type, null));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<XMLSchemaCollectionDefinition> getXMLSchemaCollections0() throws SQLException {
        ArrayList<XMLSchemaCollectionDefinition> result = new ArrayList<XMLSchemaCollectionDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.CLICKHOUSE);
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, org.jooq.meta.clickhouse.information_schema.Tables.COLUMNS, org.jooq.meta.clickhouse.information_schema.Tables.COLUMNS.TABLE_SCHEMA, org.jooq.meta.clickhouse.information_schema.Tables.COLUMNS.TABLE_NAME, org.jooq.meta.clickhouse.information_schema.Tables.COLUMNS.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, org.jooq.meta.clickhouse.information_schema.Tables.TABLES, org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_SCHEMA, org.jooq.meta.clickhouse.information_schema.Tables.TABLES.TABLE_NAME);
    }

    record TableRecord(String schema, String table, TableOptions.TableType type, String comment) {
    }
}

