/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.CheckResult;
import kotlin.reflect.jvm.internal.impl.util.Checks;
import kotlin.reflect.jvm.internal.impl.util.IsKPropertyCheck;
import kotlin.reflect.jvm.internal.impl.util.MemberKindCheck;
import kotlin.reflect.jvm.internal.impl.util.NoDefaultAndVarargsCheck;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import kotlin.reflect.jvm.internal.impl.util.ReturnsCheck;
import kotlin.reflect.jvm.internal.impl.util.ValueParameterCountCheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OperatorChecks {
    private static final List<Checks> CHECKS;
    public static final OperatorChecks INSTANCE;

    private final String ensure(boolean cond, Function0<String> msg) {
        return !cond ? (String)msg.invoke() : (String)null;
    }

    @NotNull
    public final CheckResult checkOperator(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        for (Checks check : CHECKS) {
            if (!check.isApplicable(functionDescriptor)) continue;
            return check.checkAll(functionDescriptor);
        }
        return CheckResult.IllegalFunctionName.INSTANCE;
    }

    private OperatorChecks() {
        INSTANCE = this;
        Object[] objectArray = new Checks[17];
        Name name = OperatorNameConventions.GET;
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"GET");
        objectArray[0] = new Checks(name, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(1)}, null, 4, null);
        Name name2 = OperatorNameConventions.SET;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"SET");
        objectArray[1] = new Checks(name2, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(2)}, (Function1<? super FunctionDescriptor, String>)((Function1)CHECKS.1.INSTANCE));
        Name name3 = OperatorNameConventions.GET_VALUE;
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"GET_VALUE");
        objectArray[2] = new Checks(name3, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(2), IsKPropertyCheck.INSTANCE}, null, 4, null);
        Name name4 = OperatorNameConventions.SET_VALUE;
        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"SET_VALUE");
        objectArray[3] = new Checks(name4, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(3), IsKPropertyCheck.INSTANCE}, null, 4, null);
        Name name5 = OperatorNameConventions.INVOKE;
        Intrinsics.checkExpressionValueIsNotNull((Object)name5, (String)"INVOKE");
        objectArray[4] = new Checks(name5, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE}, null, 4, null);
        Name name6 = OperatorNameConventions.CONTAINS;
        Intrinsics.checkExpressionValueIsNotNull((Object)name6, (String)"CONTAINS");
        objectArray[5] = new Checks(name6, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE}, null, 4, null);
        Name name7 = OperatorNameConventions.ITERATOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)name7, (String)"ITERATOR");
        objectArray[6] = new Checks(name7, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name8 = OperatorNameConventions.NEXT;
        Intrinsics.checkExpressionValueIsNotNull((Object)name8, (String)"NEXT");
        objectArray[7] = new Checks(name8, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name9 = OperatorNameConventions.HAS_NEXT;
        Intrinsics.checkExpressionValueIsNotNull((Object)name9, (String)"HAS_NEXT");
        objectArray[8] = new Checks(name9, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE}, null, 4, null);
        Name name10 = OperatorNameConventions.RANGE_TO;
        Intrinsics.checkExpressionValueIsNotNull((Object)name10, (String)"RANGE_TO");
        objectArray[9] = new Checks(name10, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        Name name11 = OperatorNameConventions.EQUALS;
        Intrinsics.checkExpressionValueIsNotNull((Object)name11, (String)"EQUALS");
        objectArray[10] = new Checks(name11, new Check[]{MemberKindCheck.Member.INSTANCE}, (Function1<? super FunctionDescriptor, String>)((Function1)CHECKS.2.INSTANCE));
        Name name12 = OperatorNameConventions.COMPARE_TO;
        Intrinsics.checkExpressionValueIsNotNull((Object)name12, (String)"COMPARE_TO");
        objectArray[11] = new Checks(name12, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsInt.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        objectArray[12] = new Checks(OperatorNameConventions.BINARY_OPERATION_NAMES, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        objectArray[13] = new Checks(OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        objectArray[14] = new Checks(CollectionsKt.listOf((Object[])new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC}), new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE}, (Function1<? super FunctionDescriptor, String>)((Function1)CHECKS.3.INSTANCE));
        objectArray[15] = new Checks(OperatorNameConventions.ASSIGNMENT_OPERATIONS, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsUnit.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        objectArray[16] = new Checks(OperatorNameConventions.COMPONENT_REGEX, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        CHECKS = CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        new OperatorChecks();
    }

    @Nullable
    public static final /* synthetic */ String access$ensure(OperatorChecks $this, boolean cond, @NotNull Function0 msg) {
        return $this.ensure(cond, (Function0<String>)msg);
    }
}

