/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullableNotNullManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiReceiverParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class AnnotationTargetUtil {
    private static final Logger LOG = Logger.getInstance(AnnotationTargetUtil.class);
    public static final Set<PsiAnnotation.TargetType> DEFAULT_TARGETS = ContainerUtil.immutableSet(PsiAnnotation.TargetType.PACKAGE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.MODULE, PsiAnnotation.TargetType.RECORD_COMPONENT);
    private static final PsiAnnotation.TargetType[] PACKAGE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
    private static final PsiAnnotation.TargetType[] TYPE_USE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] ANNOTATION_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] CONSTRUCTOR_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] METHOD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] FIELD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] RECORD_COMPONENT_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.RECORD_COMPONENT, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] LOCAL_VARIABLE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] MODULE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.MODULE};

    public static PsiAnnotation.TargetType @NotNull [] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(0);
            }
            return PsiAnnotation.TargetType.EMPTY_ARRAY;
        }
        if (owner instanceof PsiType || owner instanceof PsiTypeElement) {
            if (TYPE_USE_TARGETS == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(1);
            }
            return TYPE_USE_TARGETS;
        }
        if (owner instanceof PsiTypeParameter) {
            if (TYPE_PARAMETER_TARGETS == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(2);
            }
            return TYPE_PARAMETER_TARGETS;
        }
        if (owner instanceof PsiModifierList) {
            PsiElement element = ((PsiModifierList)owner).getParent();
            if (element instanceof PsiPackageStatement) {
                if (PACKAGE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(3);
                }
                return PACKAGE_TARGETS;
            }
            if (element instanceof PsiClass) {
                if (((PsiClass)element).getModifierList() != owner) {
                    if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(4);
                    }
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (((PsiClass)element).isAnnotationType()) {
                    if (ANNOTATION_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(5);
                    }
                    return ANNOTATION_TARGETS;
                }
                if (TYPE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(6);
                }
                return TYPE_TARGETS;
            }
            if (element instanceof PsiRecordComponent) {
                if (RECORD_COMPONENT_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(7);
                }
                return RECORD_COMPONENT_TARGETS;
            }
            if (element instanceof PsiMethod) {
                if (((PsiMethod)element).isConstructor()) {
                    if (CONSTRUCTOR_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(8);
                    }
                    return CONSTRUCTOR_TARGETS;
                }
                if (METHOD_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(9);
                }
                return METHOD_TARGETS;
            }
            if (element instanceof PsiField) {
                if (FIELD_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(10);
                }
                return FIELD_TARGETS;
            }
            if (element instanceof PsiParameter) {
                PsiElement scope2 = element.getParent();
                if (scope2 instanceof PsiForeachStatement || element instanceof PsiPatternVariable) {
                    if (LOCAL_VARIABLE_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(11);
                    }
                    return LOCAL_VARIABLE_TARGETS;
                }
                if (scope2 instanceof PsiParameterList && scope2.getParent() instanceof PsiLambdaExpression && ((PsiParameter)element).getTypeElement() == null) {
                    if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(12);
                    }
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (PARAMETER_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(13);
                }
                return PARAMETER_TARGETS;
            }
            if (element instanceof PsiLocalVariable) {
                if (LOCAL_VARIABLE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(14);
                }
                return LOCAL_VARIABLE_TARGETS;
            }
            if (element instanceof PsiReceiverParameter) {
                if (TYPE_USE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(15);
                }
                return TYPE_USE_TARGETS;
            }
            if (element instanceof PsiJavaModule) {
                if (MODULE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(16);
                }
                return MODULE_TARGETS;
            }
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(17);
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> extractRequiredAnnotationTargets(@Nullable PsiAnnotationMemberValue value2) {
        if (value2 instanceof PsiReference) {
            PsiAnnotation.TargetType targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)value2));
            if (targetType != null) {
                return Collections.singleton(targetType);
            }
        } else if (value2 instanceof PsiArrayInitializerMemberValue) {
            EnumSet<PsiAnnotation.TargetType> targets = EnumSet.noneOf(PsiAnnotation.TargetType.class);
            for (PsiAnnotationMemberValue initializer2 : ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                PsiAnnotation.TargetType targetType;
                if (!(initializer2 instanceof PsiReference) || (targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)initializer2))) == null) continue;
                targets.add(targetType);
            }
            return targets;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation.TargetType translateTargetRef(@NotNull PsiReference reference2) {
        PsiElement field2;
        String name2;
        if (reference2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(18);
        }
        if (reference2 instanceof PsiJavaCodeReferenceElement && (name2 = ((PsiJavaCodeReferenceElement)reference2).getReferenceName()) != null) {
            try {
                return PsiAnnotation.TargetType.valueOf(name2);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        if ((field2 = reference2.resolve()) instanceof PsiEnumConstant) {
            String name3 = ((PsiEnumConstant)field2).getName();
            try {
                return PsiAnnotation.TargetType.valueOf(name3);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown target: " + name3);
            }
        }
        return null;
    }

    public static boolean isTypeAnnotation(@NotNull PsiAnnotation element) {
        if (element == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(19);
        }
        return AnnotationTargetUtil.findAnnotationTarget(element, PsiAnnotation.TargetType.TYPE_USE) == PsiAnnotation.TargetType.TYPE_USE;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiAnnotation annotation2, PsiAnnotation.TargetType ... types2) {
        PsiClass annotationType;
        if (annotation2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(20);
        }
        if (types2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(21);
        }
        if (types2.length != 0 && (annotationType = annotation2.resolveAnnotationType()) != null) {
            return AnnotationTargetUtil.findAnnotationTarget(annotationType, types2);
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiClass annotationType, PsiAnnotation.TargetType ... types2) {
        Set<PsiAnnotation.TargetType> targets;
        if (annotationType == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(22);
        }
        if (types2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(23);
        }
        if (types2.length != 0 && (targets = AnnotationTargetUtil.getAnnotationTargets(annotationType)) != null) {
            for (PsiAnnotation.TargetType type2 : types2) {
                if (type2 == PsiAnnotation.TargetType.UNKNOWN || !targets.contains((Object)type2)) continue;
                return type2;
            }
            return null;
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> getAnnotationTargets(@NotNull PsiClass annotationType) {
        if (annotationType == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(24);
        }
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiModifierList modifierList2 = annotationType.getModifierList();
        if (modifierList2 == null) {
            return null;
        }
        return (Set)CachedValuesManager.getCachedValue(modifierList2, () -> CachedValueProvider.Result.create(AnnotationTargetUtil.calcAnnotationTargets(modifierList2), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private static Set<PsiAnnotation.TargetType> calcAnnotationTargets(PsiModifierList modifierList2) {
        PsiAnnotation target = modifierList2.findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return DEFAULT_TARGETS;
        }
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute(target, null);
        if (attribute == null) {
            return null;
        }
        return AnnotationTargetUtil.extractRequiredAnnotationTargets(attribute.getDetachedValue());
    }

    public static void collectStrictlyTypeUseAnnotations(PsiModifierList modifierList2, List<? super PsiAnnotation> annotations2) {
        if (modifierList2 == null) {
            return;
        }
        for (PsiAnnotation annotation2 : modifierList2.getAnnotations()) {
            if (!AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList2, annotation2)) continue;
            annotations2.add(annotation2);
        }
    }

    public static PsiType keepStrictlyTypeUseAnnotations(@Nullable PsiModifierList modifierList2, @NotNull PsiType type2) {
        PsiAnnotation[] originalAnnotations;
        if (type2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(28);
        }
        if (modifierList2 == null) {
            return type2;
        }
        ArrayList<PsiAnnotation> annotations2 = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation annotation2 : originalAnnotations = type2.getAnnotations()) {
            if (!AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList2, annotation2)) continue;
            annotations2.add(annotation2);
        }
        if (originalAnnotations.length == annotations2.size()) {
            return type2;
        }
        return annotations2.isEmpty() ? type2.annotate(TypeAnnotationProvider.EMPTY) : type2.annotate(TypeAnnotationProvider.Static.create(annotations2.toArray(PsiAnnotation.EMPTY_ARRAY)));
    }

    public static boolean isStrictlyTypeUseAnnotation(PsiModifierList modifierList2, PsiAnnotation annotation2) {
        Set<PsiAnnotation.TargetType> targets;
        PsiElement parent2 = annotation2.getParent();
        if (parent2 instanceof PsiJavaCodeReferenceElement || parent2 instanceof PsiTypeElement) {
            return true;
        }
        PsiClass annotationClass = annotation2.resolveAnnotationType();
        return annotationClass != null && (targets = AnnotationTargetUtil.getAnnotationTargets(annotationClass)) != null && targets.contains((Object)PsiAnnotation.TargetType.TYPE_USE) && (targets.size() == 1 || NullableNotNullManager.isNullabilityAnnotation(annotation2) || !ContainerUtil.exists(AnnotationTargetUtil.getTargetsForLocation(modifierList2), target -> target != PsiAnnotation.TargetType.TYPE_USE && targets.contains(target)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/AnnotationTargetUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationType";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsForLocation";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/AnnotationTargetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "translateTargetRef";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTypeAnnotation";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTargets";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "keepStrictlyTypeUseAnnotations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

