/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.UnknownExtensionTypeException;
import org.jboss.shrinkwrap.api.UnknownExtensionTypeExceptionDelegator;
import org.jboss.shrinkwrap.impl.base.ExtensionLoadingException;
import org.jboss.shrinkwrap.impl.base.ExtensionWrapper;
import org.jboss.shrinkwrap.impl.base.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceExtensionLoader
implements ExtensionLoader {
    private static final Logger log = Logger.getLogger(ServiceExtensionLoader.class.getName());
    private Map<Class<?>, Class<?>> cache = new HashMap();
    private Map<Class<?>, ExtensionWrapper> extensionMappings = new HashMap();

    public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) throws UnknownExtensionTypeException {
        if (this.isCached(extensionClass)) {
            return this.createFromCache(extensionClass, baseArchive);
        }
        T object = this.createFromLoadExtension(extensionClass, baseArchive);
        this.addToCache(extensionClass, object.getClass());
        return object;
    }

    boolean isCached(Class<?> extensionClass) {
        return this.cache.containsKey(extensionClass);
    }

    private <T extends Assignable> T createFromCache(Class<T> extensionClass, Archive<?> archive) {
        Class<T> extensionImplClass = this.getFromCache(extensionClass);
        return this.createExtension(extensionImplClass, archive);
    }

    void addToCache(Class<?> extensionClass, Class<?> extensionImplClass) {
        this.cache.put(extensionClass, extensionImplClass);
    }

    <T extends Assignable> Class<T> getFromCache(Class<T> extensionClass) {
        return this.cache.get(extensionClass);
    }

    public <T extends Assignable> ServiceExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
        this.addToCache(extensionClass, extensionImplClass);
        return this;
    }

    public <T extends Assignable> String getExtensionFromExtensionMapping(Class<T> type) {
        ExtensionWrapper extensionWrapper = this.extensionMappings.get(type);
        if (extensionWrapper == null) {
            this.loadExtensionMapping(type);
        }
        if ((extensionWrapper = this.extensionMappings.get(type)) == null) {
            throw UnknownExtensionTypeExceptionDelegator.newExceptionInstance(type);
        }
        return extensionWrapper.getProperty("extension");
    }

    public boolean isOverriden(Class<?> extensionClass) {
        return this.isCached(extensionClass);
    }

    private <T extends Assignable> T createFromLoadExtension(Class<T> extensionClass, Archive<?> archive) {
        ExtensionWrapper extensionWrapper = this.loadExtensionMapping(extensionClass);
        if (extensionWrapper == null) {
            throw new RuntimeException("Failed to load ExtensionMapping");
        }
        Class<T> extensionImplClass = this.loadExtension(extensionWrapper);
        if (!extensionClass.isAssignableFrom(extensionImplClass)) {
            throw new RuntimeException("Found extension impl class " + extensionImplClass.getName() + " not assignable to extension interface " + extensionClass.getName());
        }
        return this.createExtension(extensionImplClass, archive);
    }

    private <T extends Assignable> Class<T> loadExtension(ExtensionWrapper extensionWrapper) {
        return this.loadExtensionClass(extensionWrapper.implementingClassName);
    }

    private <T extends Assignable> ExtensionWrapper loadExtensionMapping(Class<T> extensionClass) {
        URL extensionImplUrl = this.findExtensionImpl(extensionClass);
        ExtensionWrapper extensionWrapper = this.loadExtensionWrapper(extensionImplUrl, extensionClass);
        this.extensionMappings.put(extensionClass, extensionWrapper);
        return extensionWrapper;
    }

    private <T extends Assignable> URL findExtensionImpl(Class<T> extensionClass) {
        try {
            Enumeration<URL> urls = this.getClassLoader().getResources("META-INF/services/" + extensionClass.getName());
            ArrayList<URL> foundExtensions = Collections.list(urls);
            if (foundExtensions.size() == 0) {
                throw new RuntimeException("No extension implementation found for " + extensionClass.getName() + ", please verify classpath or add a extensionOverride");
            }
            if (foundExtensions.size() > 1) {
                log.warning("Multiple extension implementations found for " + extensionClass.getName() + ", please verify classpath or add a extensionOverride");
            }
            return (URL)foundExtensions.get(0);
        }
        catch (Exception e) {
            throw UnknownExtensionTypeExceptionDelegator.newExceptionInstance(extensionClass);
        }
    }

    private <T extends Assignable> ExtensionWrapper loadExtensionWrapper(URL extensionURL, Class<T> extensionClass) {
        Properties properties = new Properties();
        try {
            properties.load(extensionURL.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open stream for extensionURL " + extensionURL, e);
        }
        String implementingClassName = (String)properties.get("implementingClassName");
        if (implementingClassName == null) {
            throw new RuntimeException("Property implementingClassName is not present in " + extensionURL);
        }
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)properties.get(key);
            map.put(key, value);
        }
        return new ExtensionWrapper(implementingClassName, map, extensionClass);
    }

    private <T extends Assignable> Class<T> loadExtensionClass(String extensionClassName) {
        try {
            return this.getClassLoader().loadClass(extensionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class " + extensionClassName, e);
        }
    }

    private <T extends Assignable> T createExtension(Class<T> extensionImplClass, Archive<?> archive) {
        Assignable extension;
        Constructor<T> extensionImplConstructor = this.findConstructor(extensionImplClass);
        Class<?> constructorArg = extensionImplConstructor.getParameterTypes()[0];
        try {
            extension = constructorArg.isInstance(archive) ? (Assignable)extensionImplConstructor.newInstance(archive) : (Assignable)extensionImplConstructor.newInstance(this.load(constructorArg, archive));
        }
        catch (InstantiationException e) {
            throw new ExtensionLoadingException("Failed to instantiate class of type " + archive.getClass() + ". The underlying class can not be abstract.", e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionLoadingException("Failed to instantiate class of type " + archive.getClass() + ". The underlying constructor is inaccessible.", e);
        }
        catch (InvocationTargetException e) {
            throw new ExtensionLoadingException("Failed to instantiate class of type " + archive.getClass() + ". The underlying constructor threw an exception.", e);
        }
        return (T)extension;
    }

    private <T extends Assignable> Constructor<T> findConstructor(Class<T> extensionImplClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = SecurityActions.getConstructors(extensionImplClass)) {
            Class<?> parameter;
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != 1 || !Archive.class.isAssignableFrom(parameter = parameters[0])) continue;
            return constructor;
        }
        throw new ExtensionLoadingException("No constructor with a single argument of type " + Archive.class.getName() + " could be found");
    }

    private ClassLoader getClassLoader() {
        return SecurityActions.getThreadContextClassLoader();
    }
}

