/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporterException;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptScopesStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.task.AddScopedDependenciesTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompilingProcessor<ARCHIVETYPE extends Archive<ARCHIVETYPE>>
implements PackagingProcessor<ARCHIVETYPE> {
    private static final Logger log = Logger.getLogger(AbstractCompilingProcessor.class.getName());
    public static final String MAVEN_COMPILER_PLUGIN_KEY = "org.apache.maven.plugins:maven-compiler-plugin";
    public static final String MAVEN_COMPILER_SOURCE_VERSION = "1.5";
    public static final String MAVEN_COMPILER_TARGET_VERSION = "1.5";
    protected MavenWorkingSession session;

    protected PackagingProcessor<ARCHIVETYPE> configure(MavenWorkingSession session) {
        this.session = session;
        return this;
    }

    protected AbstractCompilingProcessor<ARCHIVETYPE> compile(File inputDirectory, File outputDirectory, ScopeType ... scopes) {
        Validate.notNullAndNoNullValues((Object[])scopes, (String)"Cannot compile sources, there were no scopes defined");
        Validate.notNull((Object)inputDirectory, (String)"Directory with sources to be compiled must not be null");
        Validate.notNull((Object)outputDirectory, (String)"Target directory for compiled sources must not be null");
        JavacCompiler compiler = new JavacCompiler();
        CompilerConfiguration configuration = this.getCompilerConfiguration();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Compiling sources from {0} directory into {1}", new Object[]{inputDirectory, outputDirectory});
        }
        new AddScopedDependenciesTask(ScopeType.values()).execute(this.session);
        AcceptScopesStrategy scopeStrategy = new AcceptScopesStrategy(scopes);
        Collection artifactResults = this.session.resolveDependencies((MavenResolutionStrategy)scopeStrategy);
        for (MavenResolvedArtifact artifact : artifactResults) {
            String classpathEntry = artifact.asFile().getAbsolutePath();
            configuration.addClasspathEntry(classpathEntry);
            if (!log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, "Adding {0} to compilation classpath", classpathEntry);
        }
        configuration.addSourceLocation(inputDirectory.getPath());
        configuration.setOutputLocation(outputDirectory.getPath());
        try {
            CompilerResult result = compiler.performCompile(configuration);
            if (!result.isSuccess()) {
                throw AbstractCompilingProcessor.constructCompilationException(result, inputDirectory);
            }
        }
        catch (CompilerException e) {
            throw new MavenImporterException("Unable to compile source at " + inputDirectory.getPath() + " due to: ", (Throwable)e);
        }
        return this;
    }

    private CompilerConfiguration getCompilerConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        Map map = this.session.getParsedPomFile().getPluginConfiguration(MAVEN_COMPILER_PLUGIN_KEY);
        if (map.isEmpty()) {
            configuration.setSourceVersion("1.5");
            configuration.setTargetVersion("1.5");
        }
        configuration.setWorkingDirectory(new File("."));
        if (map.containsKey("verbose")) {
            configuration.setVerbose(Boolean.parseBoolean(map.get("verbose").toString()));
        }
        if (Validate.isNullOrEmpty((String)configuration.getSourceVersion())) {
            configuration.setSourceVersion("1.5");
        }
        if (Validate.isNullOrEmpty((String)configuration.getTargetVersion())) {
            configuration.setTargetVersion("1.5");
        }
        return configuration;
    }

    private static MavenImporterException constructCompilationException(CompilerResult result, File sourceDirectory) {
        StringBuilder sb = new StringBuilder("Unable to compile sources at ");
        sb.append(sourceDirectory.getPath());
        sb.append(" due to following reason(s): ");
        for (CompilerMessage m : result.getCompilerMessages()) {
            sb.append(m.toString());
            sb.append(", ");
        }
        if (sb.indexOf(", ") != -1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return new MavenImporterException(sb.toString());
    }
}

