/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.microcontainer.beans.BeanFactoryAwareAspectFactory;
import org.jboss.aop.microcontainer.beans.ClassLoaderAwareGenericBeanFactory;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class GenericBeanAspectFactory
extends GenericAspectFactory
implements KernelControllerContextAware,
BeanFactoryAwareAspectFactory {
    private static final Logger log = Logger.getLogger(GenericBeanAspectFactory.class);
    protected BeanFactory factory;
    protected String name;
    protected String classname;
    protected Element element;
    protected KernelControllerContext context;

    public GenericBeanAspectFactory(String name, BeanFactory factory, Element element) {
        super(null, element);
        this.name = name;
        this.element = element;
        this.setBeanFactory(factory);
    }

    public void setBeanFactory(BeanFactory factory) {
        if (factory != null && factory instanceof GenericBeanFactory) {
            this.classname = ((GenericBeanFactory)factory).getBean();
        }
        this.factory = factory;
    }

    public String getAspectName() {
        return this.name;
    }

    public String getName() {
        return this.classname;
    }

    public String getClassname() {
        return this.classname;
    }

    public Object createPerVM() {
        return this.doCreate(null, null, null);
    }

    public Object createPerClass(Advisor advisor) {
        return this.doCreate(advisor, null, null);
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        return this.doCreate(advisor, instanceAdvisor, null);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        return this.doCreate(advisor, null, jp);
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        return this.doCreate(advisor, instanceAdvisor, jp);
    }

    public void setKernelControllerContext(KernelControllerContext context) {
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    protected Object doCreate(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        try {
            Object object;
            ClassLoader loader = this.getCreatingClassLoader(advisor);
            log.debug((Object)("Creating advice " + this.name + " with loader " + loader));
            if (this.factory instanceof ClassLoaderAwareGenericBeanFactory) {
                ((ClassLoaderAwareGenericBeanFactory)this.factory).pushLoader(loader);
            }
            if ((object = this.factory.createBean()) instanceof XmlLoadable) {
                ((XmlLoadable)object).importXml(this.element);
            }
            this.configureInstance(object, advisor, instanceAdvisor, jp);
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            if (this.factory instanceof ClassLoaderAwareGenericBeanFactory) {
                ((ClassLoaderAwareGenericBeanFactory)this.factory).popLoader();
            }
        }
    }

    private ClassLoader getCreatingClassLoader(Advisor advisor) {
        if (advisor == null) {
            return this.getLoader();
        }
        return advisor.getClassLoader();
    }
}

