/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.InterceptorEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack {
    private AspectManager manager;
    private String name;
    private List<InterceptorEntry> advices;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<InterceptorEntry> getAdvices() {
        return this.advices;
    }

    public void setAdvices(List<InterceptorEntry> advices) {
        this.advices = advices;
    }

    public List<InterceptorEntry> getClonedAdvices(Binding binding) {
        ArrayList<InterceptorEntry> entries = new ArrayList<InterceptorEntry>();
        for (InterceptorEntry entry : this.advices) {
            InterceptorEntry cloned = (InterceptorEntry)entry.clone();
            cloned.setBinding(binding);
            entries.add(cloned);
        }
        return entries;
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalStateException("Null manager");
        }
        if (this.name == null) {
            throw new IllegalStateException("Null name");
        }
        if (this.advices == null) {
            throw new IllegalStateException("Null advices");
        }
        ArrayList<InterceptorFactory> factories = new ArrayList<InterceptorFactory>();
        for (InterceptorEntry advice : this.advices) {
            factories.add(advice.getInterceptorFactory());
        }
        AdviceStack stack = new AdviceStack(this.name, factories);
        this.manager.addAdviceStack(stack);
    }

    public void stop() {
        this.manager.removeInterceptorStack(this.name);
    }
}

