/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.file;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class DirectoryCopier {
    private final File sourceDirectory;

    public DirectoryCopier(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void copyTo(File targetDirectory) throws IOException {
        this.copyTo(targetDirectory, null, null);
    }

    private void copyTo(File targetDirectory, String[] includes, String[] excludes) throws IOException {
        if (!this.sourceDirectory.exists()) {
            return;
        }
        String[] list = this.sourceDirectory.list();
        if (list == null || list.length == 0) {
            return;
        }
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            DirectoryCopier.copyFileIfModified(new File(this.sourceDirectory, includedFiles[i]), new File(targetDirectory, includedFiles[i]));
        }
    }

    public static void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
            destination.setLastModified(source.lastModified());
        }
    }
}

