/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.jboss.maven.shared.properties.CompositeMavenProjectProperties;
import org.jboss.maven.shared.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDelegate {
    public static final String[] DEFAULT_DEFAULT_INCLUDES = new String[]{"**/**"};
    private final File basedir;
    private final File baseTargetDirectory;
    private final String[] defaultIncludes;
    private final String[] defaultExcludes;
    private final Log log;
    private final Map filterProperties;

    public ResourceDelegate(MavenProject project, File baseTargetDirectory, Log log) {
        this(project, baseTargetDirectory, DEFAULT_DEFAULT_INCLUDES, null, log);
    }

    public ResourceDelegate(MavenProject project, File baseTargetDirectory, String[] defaultIncludes, String[] defaultExcludes, Log log) {
        this.basedir = project.getBasedir();
        this.baseTargetDirectory = baseTargetDirectory;
        this.defaultIncludes = defaultIncludes;
        this.defaultExcludes = defaultExcludes;
        this.log = log;
        this.filterProperties = new CompositeMavenProjectProperties(project);
    }

    public void process(Resource[] resources) throws ResourceException {
        for (Resource resource : resources) {
            this.process(resource);
        }
    }

    public void process(Resource resource) throws ResourceException {
        File destination;
        this.getLog().debug((CharSequence)("starting resource processing for : " + resource.getDirectory()));
        String[] fileNames = this.collectFileNames(resource);
        if (fileNames == null) {
            this.getLog().debug((CharSequence)"no matching files found");
            return;
        }
        File file = destination = resource.getTargetPath() == null ? this.baseTargetDirectory : new File(this.baseTargetDirectory, resource.getTargetPath());
        if (!destination.exists()) {
            destination.mkdirs();
        }
        for (String fileName : fileNames) {
            if (resource.isFiltering()) {
                ResourceDelegate.copyFilteredFile(new File(resource.getDirectory(), fileName), new File(destination, fileName), null, this.getFilterWrappers(), this.filterProperties);
                continue;
            }
            ResourceDelegate.copyFileIfModified(new File(resource.getDirectory(), fileName), new File(destination, fileName));
        }
    }

    private String[] collectFileNames(Resource resource) {
        File resourceDirectory = new File(resource.getDirectory());
        if (!(resourceDirectory.exists() || resource.getDirectory().startsWith("/") || (resourceDirectory = new File(this.basedir, resource.getDirectory())).exists())) {
            resourceDirectory = null;
        }
        if (resourceDirectory == null) {
            throw new ResourceException("could not locate specified resource directory");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        scanner.setIncludes(this.determineIncludes(resource));
        scanner.setExcludes(this.determineExcludes(resource));
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private String[] determineIncludes(Resource resource) {
        return ResourceDelegate.toStringArray(resource.getIncludes(), this.defaultIncludes);
    }

    private String[] determineExcludes(Resource resource) {
        return ResourceDelegate.toStringArray(resource.getExcludes(), this.defaultExcludes);
    }

    private FilterWrapper[] getFilterWrappers() {
        return new FilterWrapper[]{new FilterWrapper(){

            public Reader getReader(Reader fileReader, Map filterProperties) {
                return new InterpolationFilterReader(fileReader, filterProperties, "${", "}");
            }
        }, new FilterWrapper(){

            public Reader getReader(Reader fileReader, Map filterProperties) {
                return new InterpolationFilterReader(fileReader, filterProperties, "@", "@");
            }
        }};
    }

    private static void copyFilteredFile(File from, File to, String encoding, FilterWrapper[] wrappers, Map filterProperties) throws ResourceException {
        BufferedReader fileReader = null;
        OutputStreamWriter fileWriter = null;
        try {
            to.getParentFile().mkdirs();
            if (encoding == null || encoding.length() < 1) {
                fileReader = new BufferedReader(new FileReader(from));
                fileWriter = new FileWriter(to);
            } else {
                FileInputStream instream = new FileInputStream(from);
                FileOutputStream outstream = new FileOutputStream(to);
                fileReader = new BufferedReader(new InputStreamReader((InputStream)instream, encoding));
                fileWriter = new OutputStreamWriter((OutputStream)outstream, encoding);
            }
            Reader reader = fileReader;
            for (FilterWrapper wrapper : wrappers) {
                reader = wrapper.getReader(reader, filterProperties);
            }
            IOUtil.copy((Reader)reader, (Writer)fileWriter);
        }
        catch (IOException e) {
            try {
                throw new ResourceException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                IOUtil.close(fileWriter);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }

    private static void copyFileIfModified(File source, File destination) throws ResourceException {
        if (destination.lastModified() < source.lastModified()) {
            try {
                FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
                destination.setLastModified(source.lastModified());
            }
            catch (IOException e) {
                throw new ResourceException(e.getMessage(), e);
            }
        }
    }

    private Log getLog() {
        return this.log;
    }

    private static String[] toStringArray(List<String> list, String[] defaultArray) {
        if (list == null || list.isEmpty()) {
            return defaultArray;
        }
        return list.toArray(new String[list.size()]);
    }

    private static interface FilterWrapper {
        public Reader getReader(Reader var1, Map var2);
    }
}

