/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.bombuilder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="build-bom", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildBomMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String bomGroupId;
    @Parameter(required=true)
    private String bomArtifactId;
    @Parameter(required=true)
    private String bomVersion;
    @Parameter(defaultValue="")
    private String bomName;
    @Parameter(defaultValue="")
    private String bomDescription;
    @Parameter(defaultValue="bom-pom.xml")
    private String outputFilename;
    @Component
    private MavenProject mavenProject;
    @Component
    private ModelBuilder modelBuilder;
    @Component
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BOM");
        Model model = this.initializeModel();
        this.addDependencyManagement(model);
        try {
            this.writeModel(model);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to write pom file.", (Exception)e);
        }
    }

    private Model initializeModel() {
        Model pomModel = new Model();
        pomModel.setModelVersion("4.0.0");
        pomModel.setGroupId(this.bomGroupId);
        pomModel.setArtifactId(this.bomArtifactId);
        pomModel.setVersion(this.bomVersion);
        pomModel.setPackaging("pom");
        pomModel.setName(this.bomName);
        pomModel.setDescription(this.bomDescription);
        pomModel.getProperties().setProperty("project.build.sourceEncoding", "UTF-8");
        return pomModel;
    }

    private void addDependencyManagement(Model pomModel) {
        ArrayList projectArtifacts = new ArrayList(this.mavenProject.getArtifacts());
        Collections.sort(projectArtifacts);
        DependencyManagement depMgmt = new DependencyManagement();
        for (Artifact artifact : projectArtifacts) {
            Dependency dep = new Dependency();
            dep.setGroupId(artifact.getGroupId());
            dep.setArtifactId(artifact.getArtifactId());
            dep.setVersion(artifact.getVersion());
            if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
                dep.setClassifier(artifact.getClassifier());
            }
            if (!StringUtils.isEmpty((String)artifact.getType())) {
                dep.setType(artifact.getType());
            }
            depMgmt.addDependency(dep);
        }
        pomModel.setDependencyManagement(depMgmt);
        this.getLog().debug((CharSequence)("Added " + projectArtifacts.size() + " dependencies."));
    }

    private void writeModel(Model pomModel) throws IOException {
        MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
        File outputFile = new File(this.mavenProject.getBuild().getDirectory(), this.outputFilename);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(outputFile);
        mavenWriter.write((Writer)writer, pomModel);
    }
}

