/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

final class ColorUtil {
    private ColorUtil() {
    }

    static StringBuilder startFgColor(StringBuilder target, boolean trueColor, float hue, float sat, float lit, boolean darken) {
        return ColorUtil.startColor(target, 38, trueColor, hue, sat, darken ? 1.0f - lit * 0.8f : lit);
    }

    static StringBuilder startBgColor(StringBuilder target, boolean trueColor, int r, int g, int b) {
        return ColorUtil.startColor(target, 48, trueColor, r, g, b);
    }

    static StringBuilder startColor(StringBuilder target, int mode, boolean trueColor, float hue, float sat, float lit) {
        float m;
        hue /= 360.0f;
        hue -= (float)Math.floor(hue);
        sat = Math.max(0.0f, Math.min(1.0f, sat));
        lit = Math.max(0.0f, Math.min(1.0f, lit));
        float c = (1.0f - Math.abs(2.0f * lit - 1.0f)) * sat;
        float x = c * (1.0f - Math.abs(hue * 6.0f % 2.0f - 1.0f));
        float r = m = lit - c / 2.0f;
        float g = m;
        float b = m;
        switch ((int)(hue * 6.0f)) {
            case 0: {
                r += c;
                g += x;
                break;
            }
            case 1: {
                r += x;
                g += c;
                break;
            }
            case 2: {
                g += c;
                b += x;
                break;
            }
            case 3: {
                g += x;
                b += c;
                break;
            }
            case 4: {
                r += x;
                b += c;
                break;
            }
            case 5: {
                r += c;
                b += x;
            }
        }
        return ColorUtil.startColor(target, mode, trueColor, (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    static StringBuilder startColor(StringBuilder target, int mode, boolean trueColor, int r, int g, int b) {
        int col;
        if (trueColor) {
            return target.appendCodePoint(27).append('[').append(mode).append(';').append(2).append(';').append(ColorUtil.clip(r)).append(';').append(ColorUtil.clip(g)).append(';').append(ColorUtil.clip(b)).append('m');
        }
        int ar = (5 * ColorUtil.clip(r) + 127) / 255;
        int ag = (5 * ColorUtil.clip(g) + 127) / 255;
        int ab = (5 * ColorUtil.clip(b) + 127) / 255;
        if (ar == ag && ar == ab) {
            col = ((ColorUtil.clip(r) + ColorUtil.clip(g) + ColorUtil.clip(b)) * 25 + 382) / 765;
            switch (col) {
                case 0: {
                    col = 16;
                    break;
                }
                case 25: {
                    col = 231;
                    break;
                }
                default: {
                    col = 231 + col;
                    break;
                }
            }
        } else {
            col = 16 + 36 * ar + 6 * ag + ab;
        }
        return target.appendCodePoint(27).append('[').append(mode).append(';').append('5').append(';').append(col).append('m');
    }

    private static int clip(int color) {
        return Math.min(Math.max(0, color), 255);
    }

    static StringBuilder endFgColor(StringBuilder target) {
        return ColorUtil.endColor(target, 39);
    }

    static StringBuilder endBgColor(StringBuilder target) {
        return ColorUtil.endColor(target, 49);
    }

    static StringBuilder endColor(StringBuilder target, int mode) {
        return target.appendCodePoint(27).append('[').append(mode).append('m');
    }
}

